/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.parallel.example;

import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.component.catalogue.common.termination.Termination;
import org.uma.jmetal.component.catalogue.common.termination.impl.TerminationByEvaluations;
import org.uma.jmetal.component.catalogue.ea.replacement.impl.MuPlusLambdaReplacement;
import org.uma.jmetal.operator.crossover.impl.UniformCrossover;
import org.uma.jmetal.operator.mutation.impl.BitFlipMutation;
import org.uma.jmetal.operator.selection.impl.BinaryTournamentSelection;
import org.uma.jmetal.parallel.asynchronous.algorithm.impl.AsynchronousMultiThreadedGeneticAlgorithm;
import org.uma.jmetal.problem.singleobjective.OneMax;
import org.uma.jmetal.solution.binarysolution.BinarySolution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.comparator.ObjectiveComparator;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;
import org.uma.jmetal.util.observer.Observer;
import org.uma.jmetal.util.observer.impl.FitnessObserver;

public class AsynchronousMultiThreadedGeneticAlgorithmExample {
    public static void main(String[] args) {
        int populationSize = 100;
        int maxEvaluations = 25000;
        int numberOfCores = 16;
        OneMax problem = new OneMax(1024){

            public BinarySolution evaluate(BinarySolution solution) {
                super.evaluate(solution);
                this.computingDelay();
                return solution;
            }

            private void computingDelay() {
                for (long i = 0L; i < 10000L; ++i) {
                    for (long j = 0L; j < 100L; ++j) {
                        double d = Math.sin(i) * Math.cos(j);
                    }
                }
            }
        };
        double crossoverProbability = 0.9;
        UniformCrossover crossover = new UniformCrossover(crossoverProbability);
        double mutationProbability = 9.765625E-4;
        BitFlipMutation mutation = new BitFlipMutation(mutationProbability);
        BinaryTournamentSelection selection = new BinaryTournamentSelection((Comparator)new ObjectiveComparator(0));
        MuPlusLambdaReplacement replacement = new MuPlusLambdaReplacement((Comparator)new ObjectiveComparator(0));
        long initTime = System.currentTimeMillis();
        AsynchronousMultiThreadedGeneticAlgorithm geneticAlgorithm = new AsynchronousMultiThreadedGeneticAlgorithm(numberOfCores, problem, populationSize, crossover, mutation, selection, replacement, (Termination)new TerminationByEvaluations(maxEvaluations));
        FitnessObserver printObjectivesObserver = new FitnessObserver(Integer.valueOf(100));
        geneticAlgorithm.getObservable().register((Observer)printObjectivesObserver);
        geneticAlgorithm.run();
        long endTime = System.currentTimeMillis();
        Object resultList = geneticAlgorithm.getResult();
        JMetalLogger.logger.info("Computing time: " + (endTime - initTime));
        new SolutionListOutput((List)resultList).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.csv", ",")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.csv", ",")).print();
        System.exit(0);
    }
}

