/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective;

import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.problem.ConstrainedProblem;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;

public class Binh2
extends AbstractDoubleProblem
implements ConstrainedProblem<DoubleSolution> {
    public Binh2() {
        this.setNumberOfVariables(2);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(2);
        this.setName("Binh2");
        List<Double> lowerLimit = Arrays.asList(0.0, 0.0);
        List<Double> upperLimit = Arrays.asList(5.0, 3.0);
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
    }

    public void evaluate(DoubleSolution solution) {
        double[] fx = new double[this.getNumberOfObjectives()];
        double[] x = new double[this.getNumberOfVariables()];
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            x[i] = (Double)solution.getVariableValue(i);
        }
        fx[0] = 4.0 * x[0] * x[0] + 4.0 * x[1] * x[1];
        fx[1] = (x[0] - 5.0) * (x[0] - 5.0) + (x[1] - 5.0) * (x[1] - 5.0);
        solution.setObjective(0, fx[0]);
        solution.setObjective(1, fx[1]);
    }

    public void evaluateConstraints(DoubleSolution solution) {
        double[] constraint = new double[this.getNumberOfConstraints()];
        double x0 = (Double)solution.getVariableValue(0);
        double x1 = (Double)solution.getVariableValue(1);
        constraint[0] = -1.0 * (x0 - 5.0) * (x0 - 5.0) - x1 * x1 + 25.0;
        constraint[1] = (x0 - 8.0) * (x0 - 8.0) + (x1 + 3.0) * (x1 + 3.0) - 7.7;
        double total = 0.0;
        int number = 0;
        for (int i = 0; i < this.getNumberOfConstraints(); ++i) {
            if (!(constraint[i] < 0.0)) continue;
            total += constraint[i];
            ++number;
        }
        solution.setOverallConstraintViolationDegree(total);
        solution.setNumberOfViolatedConstraints(number);
    }
}

