/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective;

import java.util.ArrayList;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.impl.GenericDoubleSolution;

public class Kursawe
extends AbstractDoubleProblem {
    public Kursawe() {
        this(3);
    }

    public Kursawe(Integer numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(2);
        this.setName("Kursawe");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-5.0);
            upperLimit.add(5.0);
        }
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
    }

    public DoubleSolution createSolution() {
        return new GenericDoubleSolution((DoubleProblem)this);
    }

    public void evaluate(DoubleSolution solution) {
        int var;
        double[] fx = new double[this.getNumberOfObjectives()];
        double[] x = new double[this.getNumberOfVariables()];
        for (int i = 0; i < solution.getNumberOfVariables(); ++i) {
            x[i] = (Double)solution.getVariableValue(i);
        }
        fx[0] = 0.0;
        for (var = 0; var < solution.getNumberOfVariables() - 1; ++var) {
            double xi = x[var] * x[var];
            double xj = x[var + 1] * x[var + 1];
            double aux = -0.2 * Math.sqrt(xi + xj);
            fx[0] = fx[0] + -10.0 * Math.exp(aux);
        }
        fx[1] = 0.0;
        for (var = 0; var < solution.getNumberOfVariables(); ++var) {
            fx[1] = fx[1] + (Math.pow(Math.abs(x[var]), 0.8) + 5.0 * Math.sin(Math.pow(x[var], 3.0)));
        }
        solution.setObjective(0, fx[0]);
        solution.setObjective(1, fx[1]);
    }
}

