/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective;

import java.util.ArrayList;
import org.uma.jmetal.problem.IntegerDoubleProblem;
import org.uma.jmetal.problem.impl.AbstractIntegerDoubleProblem;
import org.uma.jmetal.solution.IntegerDoubleSolution;
import org.uma.jmetal.solution.impl.GenericIntegerDoubleSolution;

public class NMMin2
extends AbstractIntegerDoubleProblem<IntegerDoubleSolution> {
    private int valueN;
    private int valueM;

    public NMMin2() {
        this(10, 10, 100, -100, -1000, 1000);
    }

    public NMMin2(int numberOfIntegerVariables, int numberOfDoubleVariables, int n, int m, int lowerBound, int upperBound) {
        this.setNumberOfIntegerVariables(numberOfIntegerVariables);
        this.setNumberOfDoubleVariables(numberOfDoubleVariables);
        this.valueN = n;
        this.valueM = m;
        this.setNumberOfVariables(numberOfIntegerVariables + numberOfDoubleVariables);
        this.setNumberOfObjectives(2);
        this.setName("NMMin");
        ArrayList<Integer> lowerLimit = new ArrayList<Integer>(this.getNumberOfVariables());
        ArrayList<Integer> upperLimit = new ArrayList<Integer>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(lowerBound);
            upperLimit.add(upperBound);
        }
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
    }

    public IntegerDoubleSolution createSolution() {
        return new GenericIntegerDoubleSolution((IntegerDoubleProblem)this);
    }

    public void evaluate(IntegerDoubleSolution solution) {
        int i;
        int approximationToN = 0;
        int approximationToM = 0;
        for (i = 0; i < solution.getNumberOfIntegerVariables(); ++i) {
            int value = ((Number)solution.getVariableValue(i)).intValue();
            approximationToN += Math.abs(this.valueN - value);
            approximationToM += Math.abs(this.valueM - value);
        }
        for (i = solution.getNumberOfIntegerVariables(); i < solution.getNumberOfIntegerVariables() + solution.getNumberOfDoubleVariables(); ++i) {
            double value = ((Number)solution.getVariableValue(i)).doubleValue();
            approximationToN = (int)((double)approximationToN + Math.abs((double)this.valueN - value));
            approximationToM = (int)((double)approximationToM + Math.abs((double)this.valueM - value));
        }
        solution.setObjective(0, (double)approximationToN);
        solution.setObjective(1, (double)approximationToM);
    }
}

