/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective;

import java.util.BitSet;
import org.uma.jmetal.problem.BinaryProblem;
import org.uma.jmetal.problem.impl.AbstractBinaryProblem;
import org.uma.jmetal.solution.BinarySolution;
import org.uma.jmetal.solution.impl.GenericBinarySolution;
import org.uma.jmetal.util.JMetalException;

public class OneZeroMax
extends AbstractBinaryProblem {
    private int bits;

    public OneZeroMax() throws JMetalException {
        this(512);
    }

    public OneZeroMax(Integer numberOfBits) throws JMetalException {
        this.setNumberOfVariables(1);
        this.setNumberOfObjectives(2);
        this.setName("OneZeroMax");
        this.bits = numberOfBits;
    }

    protected int getBitsPerVariable(int index) {
        if (index != 0) {
            throw new JMetalException("Problem OneZeroMax has only a variable. Index = " + index);
        }
        return this.bits;
    }

    public BinarySolution createSolution() {
        return new GenericBinarySolution((BinaryProblem)this);
    }

    public void evaluate(BinarySolution solution) {
        int counterOnes = 0;
        int counterZeroes = 0;
        BitSet bitset = (BitSet)solution.getVariableValue(0);
        for (int i = 0; i < bitset.length(); ++i) {
            if (bitset.get(i)) {
                ++counterOnes;
                continue;
            }
            ++counterZeroes;
        }
        solution.setObjective(0, -1.0 * (double)counterOnes);
        solution.setObjective(1, -1.0 * (double)counterZeroes);
    }
}

