/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.cec2009Competition;

import java.util.ArrayList;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;

public class UF10
extends AbstractDoubleProblem {
    public UF10() {
        this(30);
    }

    public UF10(int numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(0);
        this.setName("UF10");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        lowerLimit.add(0.0);
        upperLimit.add(1.0);
        lowerLimit.add(0.0);
        upperLimit.add(1.0);
        for (int i = 2; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-2.0);
            upperLimit.add(2.0);
        }
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
    }

    public void evaluate(DoubleSolution solution) {
        double[] x = new double[this.getNumberOfVariables()];
        for (int i = 0; i < solution.getNumberOfVariables(); ++i) {
            x[i] = (Double)solution.getVariableValue(i);
        }
        double sum3 = 0.0;
        double sum2 = 0.0;
        double sum1 = 0.0;
        int count3 = 0;
        int count2 = 0;
        int count1 = 0;
        for (int j = 3; j <= this.getNumberOfVariables(); ++j) {
            double yj = x[j - 1] - 2.0 * x[1] * Math.sin(Math.PI * 2 * x[0] + (double)j * Math.PI / (double)this.getNumberOfVariables());
            double hj = 4.0 * yj * yj - Math.cos(Math.PI * 8 * yj) + 1.0;
            if (j % 3 == 1) {
                sum1 += hj;
                ++count1;
                continue;
            }
            if (j % 3 == 2) {
                sum2 += hj;
                ++count2;
                continue;
            }
            sum3 += hj;
            ++count3;
        }
        solution.setObjective(0, Math.cos(1.5707963267948966 * x[0]) * Math.cos(1.5707963267948966 * x[1]) + 2.0 * sum1 / (double)count1);
        solution.setObjective(1, Math.cos(1.5707963267948966 * x[0]) * Math.sin(1.5707963267948966 * x[1]) + 2.0 * sum2 / (double)count2);
        solution.setObjective(2, Math.sin(1.5707963267948966 * x[0]) + 2.0 * sum3 / (double)count3);
    }
}

