/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.dtlz;

import java.util.ArrayList;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;

public class DTLZ5
extends AbstractDoubleProblem {
    public DTLZ5() {
        this(12, 3);
    }

    public DTLZ5(Integer numberOfVariables, Integer numberOfObjectives) throws JMetalException {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(numberOfObjectives);
        this.setName("DTLZ5");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(0.0);
            upperLimit.add(1.0);
        }
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
    }

    public void evaluate(DoubleSolution solution) {
        int i;
        int i2;
        int numberOfVariables = this.getNumberOfVariables();
        int numberOfObjectives = this.getNumberOfObjectives();
        double[] theta = new double[numberOfObjectives - 1];
        double g = 0.0;
        double[] f = new double[numberOfObjectives];
        double[] x = new double[numberOfVariables];
        int k = this.getNumberOfVariables() - this.getNumberOfObjectives() + 1;
        for (i2 = 0; i2 < numberOfVariables; ++i2) {
            x[i2] = (Double)solution.getVariableValue(i2);
        }
        for (i2 = numberOfVariables - k; i2 < numberOfVariables; ++i2) {
            g += (x[i2] - 0.5) * (x[i2] - 0.5);
        }
        double t = Math.PI / (4.0 * (1.0 + g));
        theta[0] = x[0] * Math.PI / 2.0;
        for (i = 1; i < numberOfObjectives - 1; ++i) {
            theta[i] = t * (1.0 + 2.0 * g * x[i]);
        }
        for (i = 0; i < numberOfObjectives; ++i) {
            f[i] = 1.0 + g;
        }
        for (i = 0; i < numberOfObjectives; ++i) {
            for (int j = 0; j < numberOfObjectives - (i + 1); ++j) {
                int n = i;
                f[n] = f[n] * Math.cos(theta[j]);
            }
            if (i == 0) continue;
            int aux = numberOfObjectives - (i + 1);
            int n = i;
            f[n] = f[n] * Math.sin(theta[aux]);
        }
        for (i = 0; i < numberOfObjectives; ++i) {
            solution.setObjective(i, f[i]);
        }
    }
}

