/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.singleobjective;

import java.util.ArrayList;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.problem.singleobjective.cec2005competitioncode.Benchmark;
import org.uma.jmetal.problem.singleobjective.cec2005competitioncode.TestFunc;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;

public class CEC2005Problem
extends AbstractDoubleProblem {
    TestFunc testFunction;

    public CEC2005Problem(int problemID, int numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(1);
        this.setNumberOfConstraints(0);
        this.setName("CEC2005");
        Benchmark cec2005ProblemFactory = new Benchmark();
        this.testFunction = cec2005ProblemFactory.testFunctionFactory(problemID, numberOfVariables);
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        double ulimit = 0.0;
        double llimit = 0.0;
        switch (problemID) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: {
                ulimit = 100.0;
                llimit = -100.0;
                break;
            }
            case 7: 
            case 25: {
                ulimit = Double.MAX_VALUE;
                llimit = Double.MIN_VALUE;
                break;
            }
            case 8: {
                ulimit = 32.0;
                llimit = -32.0;
                break;
            }
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                ulimit = 5.0;
                llimit = -5.0;
                break;
            }
            case 11: {
                ulimit = 0.5;
                llimit = -0.5;
                break;
            }
            case 12: {
                ulimit = Math.PI;
                llimit = -Math.PI;
                break;
            }
            case 13: {
                ulimit = 3.0;
                llimit = 1.0;
                break;
            }
            default: {
                throw new JMetalException("Invalid problem value");
            }
        }
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(llimit);
            upperLimit.add(ulimit);
        }
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
    }

    public void evaluate(DoubleSolution solution) {
        int numberOfVariables = this.getNumberOfVariables();
        double[] x = new double[numberOfVariables];
        for (int i = 0; i < numberOfVariables; ++i) {
            x[i] = (Double)solution.getVariableValue(i);
        }
        double result = this.testFunction.f(x);
        solution.setObjective(0, result);
    }
}

