/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.singleobjective;

import java.util.ArrayList;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;

public class Rosenbrock
extends AbstractDoubleProblem {
    public Rosenbrock(Integer numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(1);
        this.setNumberOfConstraints(0);
        this.setName("Rosenbrock");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-5.12);
            upperLimit.add(5.12);
        }
    }

    public void evaluate(DoubleSolution solution) {
        int numberOfVariables = this.getNumberOfVariables();
        double[] f = new double[this.getNumberOfObjectives()];
        double[] x = new double[numberOfVariables];
        for (int i = 0; i < numberOfVariables; ++i) {
            x[i] = (Double)solution.getVariableValue(i);
        }
        double sum = 0.0;
        for (int i = 0; i < numberOfVariables - 1; ++i) {
            double temp1 = x[i] * x[i] - x[i + 1];
            double temp2 = x[i] - 1.0;
            sum += 100.0 * temp1 * temp1 + temp2 * temp2;
        }
        solution.setObjective(0, sum);
    }
}

