/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.singleobjective.cec2005competitioncode;

import org.uma.jmetal.problem.singleobjective.cec2005competitioncode.Benchmark;
import org.uma.jmetal.problem.singleobjective.cec2005competitioncode.TestFunc;
import org.uma.jmetal.util.JMetalException;

public class F03ShiftedRotatedHighCondElliptic
extends TestFunc {
    public static final String FUNCTION_NAME = "Shifted Rotated High Conditioned Elliptic Function";
    public static final String DEFAULT_FILE_DATA = "cec2005CompetitionResources/supportData/high_cond_elliptic_rot_data.txt";
    public static final String DEFAULT_FILE_MX_PREFIX = "cec2005CompetitionResources/supportData/Elliptic_M_D";
    public static final String DEFAULT_FILE_MX_SUFFIX = ".txt";
    private final double[] m_o;
    private final double[][] m_matrix;
    private double[] m_z;
    private double[] m_zM;
    private double constant;

    public F03ShiftedRotatedHighCondElliptic(int dimension, double bias) throws JMetalException {
        this(dimension, bias, DEFAULT_FILE_DATA, DEFAULT_FILE_MX_PREFIX + dimension + DEFAULT_FILE_MX_SUFFIX);
    }

    public F03ShiftedRotatedHighCondElliptic(int dimension, double bias, String file_data, String file_m) throws JMetalException {
        super(dimension, bias, FUNCTION_NAME);
        this.m_o = new double[this.mDimension];
        this.m_matrix = new double[this.mDimension][this.mDimension];
        this.m_z = new double[this.mDimension];
        this.m_zM = new double[this.mDimension];
        Benchmark.loadRowVectorFromFile(file_data, this.mDimension, this.m_o);
        Benchmark.loadMatrixFromFile(file_m, this.mDimension, this.mDimension, this.m_matrix);
        this.constant = Math.pow(1000000.0, 1.0 / ((double)this.mDimension - 1.0));
    }

    @Override
    public double f(double[] x) {
        double result = 0.0;
        Benchmark.shift(this.m_z, x, this.m_o);
        Benchmark.rotate(this.m_zM, this.m_z, this.m_matrix);
        double sum = 0.0;
        for (int i = 0; i < this.mDimension; ++i) {
            sum += Math.pow(this.constant, i) * this.m_zM[i] * this.m_zM[i];
        }
        result = sum + this.mBias;
        return result;
    }
}

