/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.algorithm.impl.AbstractEvolutionaryAlgorithm;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.selection.SelectionOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.util.errorchecking.JMetalException;

public abstract class AbstractGeneticAlgorithm<S, Result>
extends AbstractEvolutionaryAlgorithm<S, Result> {
    protected int maxPopulationSize;
    protected SelectionOperator<List<S>, S> selectionOperator;
    protected CrossoverOperator<S> crossoverOperator;
    protected MutationOperator<S> mutationOperator;

    public void setMaxPopulationSize(int maxPopulationSize) {
        this.maxPopulationSize = maxPopulationSize;
    }

    public int getMaxPopulationSize() {
        return this.maxPopulationSize;
    }

    public SelectionOperator<List<S>, S> getSelectionOperator() {
        return this.selectionOperator;
    }

    public CrossoverOperator<S> getCrossoverOperator() {
        return this.crossoverOperator;
    }

    public MutationOperator<S> getMutationOperator() {
        return this.mutationOperator;
    }

    public AbstractGeneticAlgorithm(Problem<S> problem) {
        this.setProblem(problem);
    }

    @Override
    protected List<S> createInitialPopulation() {
        ArrayList population = new ArrayList(this.getMaxPopulationSize());
        for (int i = 0; i < this.getMaxPopulationSize(); ++i) {
            Object newIndividual = this.getProblem().createSolution();
            population.add(newIndividual);
        }
        return population;
    }

    @Override
    protected List<S> selection(List<S> population) {
        ArrayList matingPopulation = new ArrayList(population.size());
        for (int i = 0; i < this.getMaxPopulationSize(); ++i) {
            Object solution = this.selectionOperator.execute(population);
            matingPopulation.add(solution);
        }
        return matingPopulation;
    }

    @Override
    protected List<S> reproduction(List<S> population) {
        int numberOfParents = this.crossoverOperator.getNumberOfRequiredParents();
        this.checkNumberOfParents(population, numberOfParents);
        ArrayList offspringPopulation = new ArrayList(this.getMaxPopulationSize());
        for (int i = 0; i < this.getMaxPopulationSize(); i += numberOfParents) {
            ArrayList<S> parents = new ArrayList<S>(numberOfParents);
            for (int j = 0; j < numberOfParents; ++j) {
                parents.add(population.get(i + j));
            }
            List offspring = (List)this.crossoverOperator.execute(parents);
            for (Object s : offspring) {
                this.mutationOperator.execute(s);
                offspringPopulation.add(s);
            }
        }
        return offspringPopulation;
    }

    protected void checkNumberOfParents(List<S> population, int numberOfParentsForCrossover) {
        if (population.size() % numberOfParentsForCrossover != 0) {
            throw new JMetalException("Wrong number of parents: the remainder if the population size (" + population.size() + ") is not divisible by " + numberOfParentsForCrossover);
        }
    }
}

