/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.impl;

import java.util.Comparator;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.operator.localsearch.impl.BasicLocalSearch;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.comparator.DominanceComparator;

public class DefaultLocalSearch<S extends Solution<?>>
implements Algorithm<S> {
    private Problem<S> problem;
    private int maxEvaluations;
    private MutationOperator<S> mutationOperator;
    private Comparator<S> comparator;
    private S bestSolution;

    public Problem<S> getProblem() {
        return this.problem;
    }

    public MutationOperator<S> getMutationOperator() {
        return this.mutationOperator;
    }

    public Comparator<S> getComparator() {
        return this.comparator;
    }

    public DefaultLocalSearch(int maxEvaluations, Problem<S> problem, MutationOperator<S> mutationOperator, Comparator<S> comparator) {
        this.problem = problem;
        this.mutationOperator = mutationOperator;
        this.comparator = comparator;
        this.maxEvaluations = maxEvaluations;
    }

    @Override
    public S getResult() {
        return this.bestSolution;
    }

    @Override
    public void run() {
        this.bestSolution = (Solution)this.problem.createSolution();
        this.problem.evaluate(this.bestSolution);
        BasicLocalSearch<S> localSearch = new BasicLocalSearch<S>(this.maxEvaluations, this.mutationOperator, new DominanceComparator(), this.problem);
        this.bestSolution = (Solution)localSearch.execute(this.bestSolution);
    }

    @Override
    public String getName() {
        return "Default local search";
    }

    @Override
    public String getDescription() {
        return "Default local search";
    }
}

