/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.crossover.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.solution.util.repairsolution.RepairDoubleSolution;
import org.uma.jmetal.solution.util.repairsolution.impl.RepairDoubleSolutionWithBoundValue;
import org.uma.jmetal.util.bounds.Bounds;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class SBXCrossover
implements CrossoverOperator<DoubleSolution> {
    private static final double EPS = 1.0E-14;
    private double distributionIndex;
    private double crossoverProbability;
    private RepairDoubleSolution solutionRepair;
    private RandomGenerator<Double> randomGenerator;

    public SBXCrossover(double crossoverProbability, double distributionIndex) {
        this(crossoverProbability, distributionIndex, new RepairDoubleSolutionWithBoundValue());
    }

    public SBXCrossover(double crossoverProbability, double distributionIndex, RandomGenerator<Double> randomGenerator) {
        this(crossoverProbability, distributionIndex, new RepairDoubleSolutionWithBoundValue(), randomGenerator);
    }

    public SBXCrossover(double crossoverProbability, double distributionIndex, RepairDoubleSolution solutionRepair) {
        this(crossoverProbability, distributionIndex, solutionRepair, () -> JMetalRandom.getInstance().nextDouble());
    }

    public SBXCrossover(double crossoverProbability, double distributionIndex, RepairDoubleSolution solutionRepair, RandomGenerator<Double> randomGenerator) {
        Check.probabilityIsValid(crossoverProbability);
        Check.that(distributionIndex >= 0.0, "Distribution index is negative: " + distributionIndex);
        this.crossoverProbability = crossoverProbability;
        this.distributionIndex = distributionIndex;
        this.solutionRepair = solutionRepair;
        this.randomGenerator = randomGenerator;
    }

    @Override
    public double getCrossoverProbability() {
        return this.crossoverProbability;
    }

    public double getDistributionIndex() {
        return this.distributionIndex;
    }

    public void setCrossoverProbability(double probability) {
        this.crossoverProbability = probability;
    }

    public void setDistributionIndex(double distributionIndex) {
        this.distributionIndex = distributionIndex;
    }

    @Override
    public List<DoubleSolution> execute(List<DoubleSolution> solutions) {
        Check.notNull(solutions);
        Check.that(solutions.size() == 2, "There must be two parents instead of " + solutions.size());
        return this.doCrossover(this.crossoverProbability, solutions.get(0), solutions.get(1));
    }

    public List<DoubleSolution> doCrossover(double probability, DoubleSolution parent1, DoubleSolution parent2) {
        ArrayList<DoubleSolution> offspring = new ArrayList<DoubleSolution>(2);
        offspring.add((DoubleSolution)parent1.copy());
        offspring.add((DoubleSolution)parent2.copy());
        if (this.randomGenerator.getRandomValue() <= probability) {
            for (int i = 0; i < parent1.variables().size(); ++i) {
                double valueX1 = (Double)parent1.variables().get(i);
                double valueX2 = (Double)parent2.variables().get(i);
                if (this.randomGenerator.getRandomValue() <= 0.5) {
                    if (Math.abs(valueX1 - valueX2) > 1.0E-14) {
                        double y2;
                        double y1;
                        if (valueX1 < valueX2) {
                            y1 = valueX1;
                            y2 = valueX2;
                        } else {
                            y1 = valueX2;
                            y2 = valueX1;
                        }
                        Bounds<Double> bounds = parent1.getBounds(i);
                        double lowerBound = bounds.getLowerBound();
                        double upperBound = bounds.getUpperBound();
                        double rand = this.randomGenerator.getRandomValue();
                        double beta = 1.0 + 2.0 * (y1 - lowerBound) / (y2 - y1);
                        double alpha = 2.0 - Math.pow(beta, -(this.distributionIndex + 1.0));
                        double betaq = rand <= 1.0 / alpha ? Math.pow(rand * alpha, 1.0 / (this.distributionIndex + 1.0)) : Math.pow(1.0 / (2.0 - rand * alpha), 1.0 / (this.distributionIndex + 1.0));
                        double c1 = 0.5 * (y1 + y2 - betaq * (y2 - y1));
                        beta = 1.0 + 2.0 * (upperBound - y2) / (y2 - y1);
                        alpha = 2.0 - Math.pow(beta, -(this.distributionIndex + 1.0));
                        betaq = rand <= 1.0 / alpha ? Math.pow(rand * alpha, 1.0 / (this.distributionIndex + 1.0)) : Math.pow(1.0 / (2.0 - rand * alpha), 1.0 / (this.distributionIndex + 1.0));
                        double c2 = 0.5 * (y1 + y2 + betaq * (y2 - y1));
                        c1 = this.solutionRepair.repairSolutionVariableValue(c1, lowerBound, upperBound);
                        c2 = this.solutionRepair.repairSolutionVariableValue(c2, lowerBound, upperBound);
                        if (this.randomGenerator.getRandomValue() <= 0.5) {
                            ((DoubleSolution)offspring.get(0)).variables().set(i, c2);
                            ((DoubleSolution)offspring.get(1)).variables().set(i, c1);
                            continue;
                        }
                        ((DoubleSolution)offspring.get(0)).variables().set(i, c1);
                        ((DoubleSolution)offspring.get(1)).variables().set(i, c2);
                        continue;
                    }
                    ((DoubleSolution)offspring.get(0)).variables().set(i, valueX1);
                    ((DoubleSolution)offspring.get(1)).variables().set(i, valueX2);
                    continue;
                }
                ((DoubleSolution)offspring.get(0)).variables().set(i, valueX2);
                ((DoubleSolution)offspring.get(1)).variables().set(i, valueX1);
            }
        }
        return offspring;
    }

    @Override
    public int getNumberOfRequiredParents() {
        return 2;
    }

    @Override
    public int getNumberOfGeneratedChildren() {
        return 2;
    }
}

