/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.crossover.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.solution.binarysolution.BinarySolution;
import org.uma.jmetal.util.binarySet.BinarySet;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class UniformCrossover
implements CrossoverOperator<BinarySolution> {
    private double crossoverProbability;
    private RandomGenerator<Double> crossoverRandomGenerator;

    public UniformCrossover(double crossoverProbability) {
        this(crossoverProbability, () -> JMetalRandom.getInstance().nextDouble());
    }

    public UniformCrossover(double crossoverProbability, RandomGenerator<Double> crossoverRandomGenerator) {
        if (crossoverProbability < 0.0) {
            throw new JMetalException("Crossover probability is negative: " + crossoverProbability);
        }
        this.crossoverProbability = crossoverProbability;
        this.crossoverRandomGenerator = crossoverRandomGenerator;
    }

    @Override
    public double getCrossoverProbability() {
        return this.crossoverProbability;
    }

    public void setCrossoverProbability(double crossoverProbability) {
        this.crossoverProbability = crossoverProbability;
    }

    @Override
    public List<BinarySolution> execute(List<BinarySolution> solutions) {
        Check.notNull(solutions);
        Check.that(solutions.size() == 2, "There must be two parents instead of " + solutions.size());
        return this.doCrossover(this.crossoverProbability, solutions.get(0), solutions.get(1));
    }

    public List<BinarySolution> doCrossover(double probability, BinarySolution parent1, BinarySolution parent2) {
        ArrayList<BinarySolution> offspring = new ArrayList<BinarySolution>(2);
        offspring.add((BinarySolution)parent1.copy());
        offspring.add((BinarySolution)parent2.copy());
        if (this.crossoverRandomGenerator.getRandomValue() < probability) {
            for (int variableIndex = 0; variableIndex < parent1.variables().size(); ++variableIndex) {
                for (int bitIndex = 0; bitIndex < ((BinarySet)parent1.variables().get(variableIndex)).getBinarySetLength(); ++bitIndex) {
                    if (!(this.crossoverRandomGenerator.getRandomValue() < 0.5)) continue;
                    ((BinarySet)((BinarySolution)offspring.get(0)).variables().get(variableIndex)).set(bitIndex, ((BinarySet)parent2.variables().get(variableIndex)).get(bitIndex));
                    ((BinarySet)((BinarySolution)offspring.get(1)).variables().get(variableIndex)).set(bitIndex, ((BinarySet)parent1.variables().get(variableIndex)).get(bitIndex));
                }
            }
        }
        return offspring;
    }

    @Override
    public int getNumberOfRequiredParents() {
        return 2;
    }

    @Override
    public int getNumberOfGeneratedChildren() {
        return 2;
    }
}

