/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.crossover.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.solution.util.repairsolution.RepairDoubleSolution;
import org.uma.jmetal.solution.util.repairsolution.impl.RepairDoubleSolutionWithBoundValue;
import org.uma.jmetal.util.bounds.Bounds;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class WholeArithmeticCrossover
implements CrossoverOperator<DoubleSolution> {
    private double crossoverProbability;
    private RepairDoubleSolution solutionRepair;
    private RandomGenerator<Double> randomGenerator;

    public WholeArithmeticCrossover(double crossoverProbability) {
        this(crossoverProbability, new RepairDoubleSolutionWithBoundValue());
    }

    public WholeArithmeticCrossover(double crossoverProbability, RepairDoubleSolution solutionRepair) {
        this(crossoverProbability, solutionRepair, () -> JMetalRandom.getInstance().nextDouble());
    }

    public WholeArithmeticCrossover(double crossoverProbability, RepairDoubleSolution solutionRepair, RandomGenerator<Double> randomGenerator) {
        Check.probabilityIsValid(crossoverProbability);
        this.crossoverProbability = crossoverProbability;
        this.randomGenerator = randomGenerator;
        this.solutionRepair = solutionRepair;
    }

    @Override
    public double getCrossoverProbability() {
        return this.crossoverProbability;
    }

    public void setCrossoverProbability(double crossoverProbability) {
        this.crossoverProbability = crossoverProbability;
    }

    @Override
    public List<DoubleSolution> execute(List<DoubleSolution> solutions) {
        Check.notNull(solutions);
        Check.that(solutions.size() == 2, "There must be two parents instead of " + solutions.size());
        return this.doCrossover(this.crossoverProbability, solutions.get(0), solutions.get(1));
    }

    public List<DoubleSolution> doCrossover(double probability, DoubleSolution parent1, DoubleSolution parent2) {
        ArrayList<DoubleSolution> offspring = new ArrayList<DoubleSolution>(2);
        offspring.add((DoubleSolution)parent1.copy());
        offspring.add((DoubleSolution)parent2.copy());
        if (this.randomGenerator.getRandomValue() <= probability) {
            double alpha = this.randomGenerator.getRandomValue();
            for (int i = 0; i < parent1.variables().size(); ++i) {
                Bounds<Double> bounds = parent1.getBounds(i);
                double upperBound = bounds.getUpperBound();
                double lowerBound = bounds.getLowerBound();
                double valueX1 = alpha * (Double)parent1.variables().get(i) + (1.0 - alpha) * (Double)parent2.variables().get(i);
                double valueX2 = alpha * (Double)parent2.variables().get(i) + (1.0 - alpha) * (Double)parent1.variables().get(i);
                valueX1 = this.solutionRepair.repairSolutionVariableValue(valueX1, lowerBound, upperBound);
                valueX2 = this.solutionRepair.repairSolutionVariableValue(valueX2, lowerBound, upperBound);
                ((DoubleSolution)offspring.get(0)).variables().set(i, valueX1);
                ((DoubleSolution)offspring.get(1)).variables().set(i, valueX2);
            }
        }
        return offspring;
    }

    @Override
    public int getNumberOfRequiredParents() {
        return 2;
    }

    @Override
    public int getNumberOfGeneratedChildren() {
        return 2;
    }
}

