/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.localsearch.impl;

import java.util.Comparator;
import org.uma.jmetal.operator.localsearch.LocalSearchOperator;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class BasicLocalSearch<S extends Solution<?>>
implements LocalSearchOperator<S> {
    private Problem<S> problem;
    private int improvementRounds;
    private Comparator<S> comparator;
    private MutationOperator<S> mutationOperator;
    private int evaluations;
    private int numberOfImprovements;
    private RandomGenerator<Double> randomGenerator;

    public BasicLocalSearch(int improvementRounds, MutationOperator<S> mutationOperator, Comparator<S> comparator, Problem<S> problem) {
        this(improvementRounds, mutationOperator, comparator, problem, () -> JMetalRandom.getInstance().nextDouble());
    }

    public BasicLocalSearch(int improvementRounds, MutationOperator<S> mutationOperator, Comparator<S> comparator, Problem<S> problem, RandomGenerator<Double> randomGenerator) {
        this.problem = problem;
        this.mutationOperator = mutationOperator;
        this.improvementRounds = improvementRounds;
        this.comparator = comparator;
        this.randomGenerator = randomGenerator;
        this.numberOfImprovements = 0;
    }

    @Override
    public S execute(S solution) {
        this.evaluations = 0;
        int rounds = this.improvementRounds;
        for (int i = 0; i < rounds; ++i) {
            Solution mutatedSolution = (Solution)this.mutationOperator.execute(solution.copy());
            this.problem.evaluate(mutatedSolution);
            ++this.evaluations;
            int best = this.comparator.compare(mutatedSolution, solution);
            if (best == -1) {
                solution = mutatedSolution;
                ++this.numberOfImprovements;
                continue;
            }
            if (best != 0 || !(this.randomGenerator.getRandomValue() < 0.5)) continue;
            solution = mutatedSolution;
        }
        return (S)solution.copy();
    }

    @Override
    public int getNumberOfEvaluations() {
        return this.evaluations;
    }

    @Override
    public int getNumberOfImprovements() {
        return this.numberOfImprovements;
    }
}

