/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.mutation.impl;

import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.solution.binarysolution.BinarySolution;
import org.uma.jmetal.util.binarySet.BinarySet;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class BitFlipMutation
implements MutationOperator<BinarySolution> {
    private double mutationProbability;
    private RandomGenerator<Double> randomGenerator;

    public BitFlipMutation(double mutationProbability) {
        this(mutationProbability, () -> JMetalRandom.getInstance().nextDouble());
    }

    public BitFlipMutation(double mutationProbability, RandomGenerator<Double> randomGenerator) {
        if (mutationProbability < 0.0) {
            throw new JMetalException("Mutation probability is negative: " + mutationProbability);
        }
        this.mutationProbability = mutationProbability;
        this.randomGenerator = randomGenerator;
    }

    @Override
    public double getMutationProbability() {
        return this.mutationProbability;
    }

    public void setMutationProbability(double mutationProbability) {
        this.mutationProbability = mutationProbability;
    }

    @Override
    public BinarySolution execute(BinarySolution solution) {
        Check.notNull(solution);
        this.doMutation(this.mutationProbability, solution);
        return solution;
    }

    public void doMutation(double probability, BinarySolution solution) {
        for (int i = 0; i < solution.variables().size(); ++i) {
            for (int j = 0; j < ((BinarySet)solution.variables().get(i)).getBinarySetLength(); ++j) {
                if (!(this.randomGenerator.getRandomValue() <= probability)) continue;
                ((BinarySet)solution.variables().get(i)).flip(j);
            }
        }
    }
}

