/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.mutation.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.solution.compositesolution.CompositeSolution;
import org.uma.jmetal.util.errorchecking.Check;

public class CompositeMutation
implements MutationOperator<CompositeSolution> {
    private List<MutationOperator<Solution<?>>> operators;
    private double mutationProbability = 1.0;

    public CompositeMutation(List<?> operators) {
        Check.notNull(operators);
        Check.collectionIsNotEmpty(operators);
        this.operators = new ArrayList();
        for (int i = 0; i < operators.size(); ++i) {
            Check.that(operators.get(i) instanceof MutationOperator, "The operator list does not contain an object implementing class CrossoverOperator");
            this.operators.add((MutationOperator)operators.get(i));
        }
    }

    @Override
    public double getMutationProbability() {
        return this.mutationProbability;
    }

    @Override
    public CompositeSolution execute(CompositeSolution solution) {
        Check.notNull(solution);
        ArrayList mutatedSolutionComponents = new ArrayList();
        int numberOfSolutionsInCompositeSolution = solution.variables().size();
        for (int i = 0; i < numberOfSolutionsInCompositeSolution; ++i) {
            mutatedSolutionComponents.add((Solution)this.operators.get(i).execute((Solution)solution.variables().get(i)));
        }
        return new CompositeSolution(mutatedSolutionComponents);
    }

    public List<MutationOperator<Solution<?>>> getOperators() {
        return this.operators;
    }
}

