/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.mutation.impl;

import java.util.List;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.solution.util.repairsolution.RepairDoubleSolution;
import org.uma.jmetal.solution.util.repairsolution.impl.RepairDoubleSolutionWithBoundValue;
import org.uma.jmetal.util.bounds.Bounds;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.grouping.CollectionGrouping;
import org.uma.jmetal.util.pseudorandom.PseudoRandomGenerator;
import org.uma.jmetal.util.pseudorandom.impl.JavaRandomGenerator;

public class GroupedPolynomialMutation
implements MutationOperator<DoubleSolution> {
    private static final double DEFAULT_DISTRIBUTION_INDEX = 20.0;
    private double distributionIndex;
    private RepairDoubleSolution solutionRepair;
    private CollectionGrouping<List<Double>> variableGrouping;
    private PseudoRandomGenerator randomGenerator;

    public GroupedPolynomialMutation(CollectionGrouping<List<Double>> variableGrouping) {
        this(20.0, variableGrouping);
    }

    public GroupedPolynomialMutation(double distributionIndex, CollectionGrouping<List<Double>> variableGrouping) {
        this(distributionIndex, new RepairDoubleSolutionWithBoundValue(), variableGrouping);
    }

    public GroupedPolynomialMutation(double distributionIndex, RepairDoubleSolution solutionRepair, CollectionGrouping<List<Double>> variableGrouping) {
        this(distributionIndex, solutionRepair, new JavaRandomGenerator(), variableGrouping);
    }

    public GroupedPolynomialMutation(double distributionIndex, RepairDoubleSolution solutionRepair, PseudoRandomGenerator randomGenerator, CollectionGrouping<List<Double>> variableGrouping) {
        Check.that(distributionIndex >= 0.0, "Distribution index is negative: " + distributionIndex);
        this.distributionIndex = distributionIndex;
        this.solutionRepair = solutionRepair;
        this.randomGenerator = randomGenerator;
        this.variableGrouping = variableGrouping;
    }

    @Override
    public double getMutationProbability() {
        return 1.0;
    }

    public double getDistributionIndex() {
        return this.distributionIndex;
    }

    public void setDistributionIndex(double distributionIndex) {
        this.distributionIndex = distributionIndex;
    }

    @Override
    public DoubleSolution execute(DoubleSolution solution) throws JMetalException {
        Check.notNull(solution);
        this.doMutation(solution);
        return solution;
    }

    private void doMutation(DoubleSolution solution) {
        this.variableGrouping.computeGroups(solution.variables());
        int groupIndex = this.randomGenerator.nextInt(0, this.variableGrouping.numberOfGroups() - 1);
        List<Integer> variableIndex = this.variableGrouping.getGroup(groupIndex);
        for (int i = 0; i < variableIndex.size(); ++i) {
            double yu;
            double y = (Double)solution.variables().get(variableIndex.get(i));
            Bounds<Double> bounds = solution.getBounds(variableIndex.get(i));
            double yl = bounds.getLowerBound();
            if (yl == (yu = bounds.getUpperBound().doubleValue())) {
                y = yl;
            } else {
                double deltaq;
                double val;
                double xy;
                double delta1 = (y - yl) / (yu - yl);
                double delta2 = (yu - y) / (yu - yl);
                double rnd = this.randomGenerator.nextDouble();
                double mutPow = 1.0 / (this.distributionIndex + 1.0);
                if (rnd <= 0.5) {
                    xy = 1.0 - delta1;
                    val = 2.0 * rnd + (1.0 - 2.0 * rnd) * Math.pow(xy, this.distributionIndex + 1.0);
                    deltaq = Math.pow(val, mutPow) - 1.0;
                } else {
                    xy = 1.0 - delta2;
                    val = 2.0 * (1.0 - rnd) + 2.0 * (rnd - 0.5) * Math.pow(xy, this.distributionIndex + 1.0);
                    deltaq = 1.0 - Math.pow(val, mutPow);
                }
                y += deltaq * (yu - yl);
                y = this.solutionRepair.repairSolutionVariableValue(y, yl, yu);
            }
            solution.variables().set(variableIndex.get(i), y);
        }
    }
}

