/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.mutation.impl;

import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.problem.integerproblem.IntegerProblem;
import org.uma.jmetal.solution.integersolution.IntegerSolution;
import org.uma.jmetal.solution.util.repairsolution.RepairDoubleSolution;
import org.uma.jmetal.solution.util.repairsolution.impl.RepairDoubleSolutionWithBoundValue;
import org.uma.jmetal.util.bounds.Bounds;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class IntegerPolynomialMutation
implements MutationOperator<IntegerSolution> {
    private static final double DEFAULT_PROBABILITY = 0.01;
    private static final double DEFAULT_DISTRIBUTION_INDEX = 20.0;
    private double distributionIndex;
    private double mutationProbability;
    private RepairDoubleSolution solutionRepair;
    private RandomGenerator<Double> randomGenerator;

    public IntegerPolynomialMutation() {
        this(0.01, 20.0);
    }

    public IntegerPolynomialMutation(IntegerProblem problem, double distributionIndex) {
        this(1.0 / (double)problem.getNumberOfVariables(), distributionIndex);
    }

    public IntegerPolynomialMutation(double mutationProbability, double distributionIndex) {
        this(mutationProbability, distributionIndex, new RepairDoubleSolutionWithBoundValue());
    }

    public IntegerPolynomialMutation(double mutationProbability, double distributionIndex, RepairDoubleSolution solutionRepair) {
        this(mutationProbability, distributionIndex, solutionRepair, () -> JMetalRandom.getInstance().nextDouble());
    }

    public IntegerPolynomialMutation(double mutationProbability, double distributionIndex, RepairDoubleSolution solutionRepair, RandomGenerator<Double> randomGenerator) {
        if (mutationProbability < 0.0) {
            throw new JMetalException("Mutation probability is negative: " + mutationProbability);
        }
        if (distributionIndex < 0.0) {
            throw new JMetalException("Distribution index is negative: " + distributionIndex);
        }
        this.mutationProbability = mutationProbability;
        this.distributionIndex = distributionIndex;
        this.solutionRepair = solutionRepair;
        this.randomGenerator = randomGenerator;
    }

    @Override
    public double getMutationProbability() {
        return this.mutationProbability;
    }

    public double getDistributionIndex() {
        return this.distributionIndex;
    }

    public void setDistributionIndex(double distributionIndex) {
        this.distributionIndex = distributionIndex;
    }

    public void setMutationProbability(double mutationProbability) {
        this.mutationProbability = mutationProbability;
    }

    @Override
    public IntegerSolution execute(IntegerSolution solution) throws JMetalException {
        if (null == solution) {
            throw new JMetalException("Null parameter");
        }
        this.doMutation(this.mutationProbability, solution);
        return solution;
    }

    private void doMutation(double probability, IntegerSolution solution) {
        for (int i = 0; i < solution.variables().size(); ++i) {
            double yu;
            if (!(this.randomGenerator.getRandomValue() <= probability)) continue;
            double y = ((Integer)solution.variables().get(i)).intValue();
            Bounds<Integer> bounds = solution.getBounds(i);
            double yl = bounds.getLowerBound().intValue();
            if (yl == (yu = (double)bounds.getUpperBound().intValue())) {
                y = yl;
            } else {
                Double deltaq;
                double val;
                double xy;
                Double delta1 = (y - yl) / (yu - yl);
                Double delta2 = (yu - y) / (yu - yl);
                Double rnd = this.randomGenerator.getRandomValue();
                Double mutPow = 1.0 / (this.distributionIndex + 1.0);
                if (rnd <= 0.5) {
                    xy = 1.0 - delta1;
                    val = 2.0 * rnd + (1.0 - 2.0 * rnd) * Math.pow(xy, this.distributionIndex + 1.0);
                    deltaq = Math.pow(val, mutPow) - 1.0;
                } else {
                    xy = 1.0 - delta2;
                    val = 2.0 * (1.0 - rnd) + 2.0 * (rnd - 0.5) * Math.pow(xy, this.distributionIndex + 1.0);
                    deltaq = 1.0 - Math.pow(val, mutPow);
                }
                y += deltaq * (yu - yl);
                y = this.solutionRepair.repairSolutionVariableValue(y, yl, yu);
            }
            solution.variables().set(i, (int)y);
        }
    }
}

