/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.mutation.impl;

import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.solution.permutationsolution.PermutationSolution;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.pseudorandom.BoundedRandomGenerator;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class PermutationSwapMutation<T>
implements MutationOperator<PermutationSolution<T>> {
    private double mutationProbability;
    private RandomGenerator<Double> mutationRandomGenerator;
    private BoundedRandomGenerator<Integer> positionRandomGenerator;

    public PermutationSwapMutation(double mutationProbability) {
        this(mutationProbability, () -> JMetalRandom.getInstance().nextDouble(), (a2, b) -> JMetalRandom.getInstance().nextInt((int)a2, (int)b));
    }

    public PermutationSwapMutation(double mutationProbability, RandomGenerator<Double> randomGenerator) {
        this(mutationProbability, randomGenerator, BoundedRandomGenerator.fromDoubleToInteger(randomGenerator));
    }

    public PermutationSwapMutation(double mutationProbability, RandomGenerator<Double> mutationRandomGenerator, BoundedRandomGenerator<Integer> positionRandomGenerator) {
        Check.probabilityIsValid(mutationProbability);
        this.mutationProbability = mutationProbability;
        this.mutationRandomGenerator = mutationRandomGenerator;
        this.positionRandomGenerator = positionRandomGenerator;
    }

    @Override
    public double getMutationProbability() {
        return this.mutationProbability;
    }

    public void setMutationProbability(double mutationProbability) {
        this.mutationProbability = mutationProbability;
    }

    @Override
    public PermutationSolution<T> execute(PermutationSolution<T> solution) {
        Check.notNull(solution);
        this.doMutation(solution);
        return solution;
    }

    public void doMutation(PermutationSolution<T> solution) {
        int permutationLength = solution.variables().size();
        if (permutationLength != 0 && permutationLength != 1 && this.mutationRandomGenerator.getRandomValue() < this.mutationProbability) {
            int pos1 = this.positionRandomGenerator.getRandomValue(0, permutationLength - 1);
            int pos2 = this.positionRandomGenerator.getRandomValue(0, permutationLength - 1);
            while (pos1 == pos2) {
                if (pos1 == permutationLength - 1) {
                    pos2 = this.positionRandomGenerator.getRandomValue(0, permutationLength - 2);
                    continue;
                }
                pos2 = this.positionRandomGenerator.getRandomValue(pos1, permutationLength - 1);
            }
            Object temp = solution.variables().get(pos1);
            solution.variables().set(pos1, solution.variables().get(pos2));
            solution.variables().set(pos2, temp);
        }
    }
}

