/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.mutation.impl;

import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.solution.util.repairsolution.RepairDoubleSolution;
import org.uma.jmetal.solution.util.repairsolution.impl.RepairDoubleSolutionWithBoundValue;
import org.uma.jmetal.util.bounds.Bounds;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class UniformMutation
implements MutationOperator<DoubleSolution> {
    private double perturbation;
    private Double mutationProbability = null;
    private RandomGenerator<Double> randomGenerator;
    private RepairDoubleSolution solutionRepair;

    public UniformMutation(double mutationProbability, double perturbation) {
        this(mutationProbability, perturbation, new RepairDoubleSolutionWithBoundValue(), () -> JMetalRandom.getInstance().nextDouble());
    }

    public UniformMutation(double mutationProbability, double perturbation, RepairDoubleSolution solutionRepair, RandomGenerator<Double> randomGenerator) {
        this.mutationProbability = mutationProbability;
        this.perturbation = perturbation;
        this.randomGenerator = randomGenerator;
        this.solutionRepair = solutionRepair;
    }

    public UniformMutation(double mutationProbability, double perturbation, RepairDoubleSolution solutionRepair) {
        this(mutationProbability, perturbation, solutionRepair, () -> JMetalRandom.getInstance().nextDouble());
    }

    public double getPerturbation() {
        return this.perturbation;
    }

    @Override
    public double getMutationProbability() {
        return this.mutationProbability;
    }

    public void setPerturbation(Double perturbation) {
        this.perturbation = perturbation;
    }

    public void setMutationProbability(Double mutationProbability) {
        this.mutationProbability = mutationProbability;
    }

    public void doMutation(double probability, DoubleSolution solution) {
        for (int i = 0; i < solution.variables().size(); ++i) {
            if (!(this.randomGenerator.getRandomValue() < probability)) continue;
            double rand = this.randomGenerator.getRandomValue();
            double tmp = (rand - 0.5) * this.perturbation;
            tmp += ((Double)solution.variables().get(i)).doubleValue();
            Bounds<Double> bounds = solution.getBounds(i);
            tmp = this.solutionRepair.repairSolutionVariableValue(tmp, bounds.getLowerBound(), bounds.getUpperBound());
            solution.variables().set(i, tmp);
        }
    }

    @Override
    public DoubleSolution execute(DoubleSolution solution) {
        Check.notNull(solution);
        this.doMutation(this.mutationProbability, solution);
        return solution;
    }
}

