/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.selection.impl;

import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.operator.selection.SelectionOperator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.comparator.DominanceComparator;
import org.uma.jmetal.util.errorchecking.Check;

public class NaryTournamentSelection<S extends Solution<?>>
implements SelectionOperator<List<S>, S> {
    private Comparator<S> comparator;
    private int tournamentSize;

    public NaryTournamentSelection() {
        this(2, new DominanceComparator());
    }

    public NaryTournamentSelection(int tournamentSize, Comparator<S> comparator) {
        this.tournamentSize = tournamentSize;
        this.comparator = comparator;
    }

    @Override
    public S execute(List<S> solutionList) {
        Solution result;
        Check.notNull(solutionList);
        Check.collectionIsNotEmpty(solutionList);
        Check.that(solutionList.size() >= this.tournamentSize, "The solution list size (" + solutionList.size() + ") is less than the number of requested solutions (" + this.tournamentSize + ")");
        if (solutionList.size() == 1) {
            result = (Solution)solutionList.get(0);
        } else {
            List<S> selectedSolutions = SolutionListUtils.selectNRandomDifferentSolutions(this.tournamentSize, solutionList);
            result = (Solution)SolutionListUtils.findBestSolution(selectedSolutions, this.comparator);
        }
        return (S)result;
    }

    public int getTournamentSize() {
        return this.tournamentSize;
    }
}

