/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.selection.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.operator.selection.SelectionOperator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.comparator.DominanceComparator;
import org.uma.jmetal.util.densityestimator.impl.CrowdingDistanceDensityEstimator;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.ranking.Ranking;
import org.uma.jmetal.util.ranking.impl.FastNonDominatedSortRanking;

public class RankingAndCrowdingSelection<S extends Solution<?>>
implements SelectionOperator<List<S>, List<S>> {
    private final int solutionsToSelect;
    private Comparator<S> dominanceComparator;

    public RankingAndCrowdingSelection(int solutionsToSelect, Comparator<S> dominanceComparator) {
        this.dominanceComparator = dominanceComparator;
        this.solutionsToSelect = solutionsToSelect;
    }

    public RankingAndCrowdingSelection(int solutionsToSelect) {
        this(solutionsToSelect, new DominanceComparator());
    }

    public int getNumberOfSolutionsToSelect() {
        return this.solutionsToSelect;
    }

    @Override
    public List<S> execute(List<S> solutionList) throws JMetalException {
        if (null == solutionList) {
            throw new JMetalException("The solution list is null");
        }
        if (solutionList.isEmpty()) {
            throw new JMetalException("The solution list is empty");
        }
        if (solutionList.size() < this.solutionsToSelect) {
            throw new JMetalException("The population size (" + solutionList.size() + ") is smaller thanthe solutions to selected (" + this.solutionsToSelect + ")");
        }
        FastNonDominatedSortRanking<S> ranking = new FastNonDominatedSortRanking<S>(this.dominanceComparator);
        ranking.compute(solutionList);
        return this.crowdingDistanceSelection(ranking);
    }

    protected List<S> crowdingDistanceSelection(Ranking<S> ranking) {
        CrowdingDistanceDensityEstimator<S> crowdingDistance = new CrowdingDistanceDensityEstimator<S>();
        ArrayList population = new ArrayList(this.solutionsToSelect);
        int rankingIndex = 0;
        while (population.size() < this.solutionsToSelect) {
            if (this.subfrontFillsIntoThePopulation(ranking, rankingIndex, population)) {
                crowdingDistance.compute(ranking.getSubFront(rankingIndex));
                this.addRankedSolutionsToPopulation(ranking, rankingIndex, population);
                ++rankingIndex;
                continue;
            }
            crowdingDistance.compute(ranking.getSubFront(rankingIndex));
            this.addLastRankedSolutionsToPopulation(ranking, rankingIndex, population);
        }
        return population;
    }

    protected boolean subfrontFillsIntoThePopulation(Ranking<S> ranking, int rank, List<S> population) {
        return ranking.getSubFront(rank).size() < this.solutionsToSelect - population.size();
    }

    protected void addRankedSolutionsToPopulation(Ranking<S> ranking, int rank, List<S> population) {
        List<S> front = ranking.getSubFront(rank);
        front.forEach(population::add);
    }

    protected void addLastRankedSolutionsToPopulation(Ranking<S> ranking, int rank, List<S> population) {
        List<S> currentRankedFront = ranking.getSubFront(rank);
        currentRankedFront.sort(new CrowdingDistanceDensityEstimator().getComparator());
        int i = 0;
        while (population.size() < this.solutionsToSelect) {
            population.add((Solution)currentRankedFront.get(i));
            ++i;
        }
    }
}

