/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.selection.impl;

import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.operator.selection.SelectionOperator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.SolutionUtils;
import org.uma.jmetal.util.comparator.RankingAndSSDComparator;
import org.uma.jmetal.util.errorchecking.Check;

public class SpatialSpreadDeviationSelection<S extends Solution<?>>
implements SelectionOperator<List<S>, S> {
    private Comparator<S> comparator;
    private final int numberOfTournaments;

    public SpatialSpreadDeviationSelection(int numberOfTournaments) {
        this(new RankingAndSSDComparator(), numberOfTournaments);
    }

    public SpatialSpreadDeviationSelection(Comparator<S> comparator, int numberOfTournaments) {
        this.numberOfTournaments = numberOfTournaments;
        this.comparator = comparator;
    }

    @Override
    public S execute(List<S> solutionList) {
        Solution result;
        Check.notNull(solutionList);
        Check.collectionIsNotEmpty(solutionList);
        if (solutionList.size() == 1) {
            result = (Solution)solutionList.get(0);
        } else {
            result = (Solution)SolutionListUtils.selectNRandomDifferentSolutions(1, solutionList).get(0);
            int count = 1;
            do {
                Solution candidate = (Solution)SolutionListUtils.selectNRandomDifferentSolutions(1, solutionList).get(0);
                result = SolutionUtils.getBestSolution(result, candidate, this.comparator);
            } while (++count < this.numberOfTournaments);
        }
        return (S)result;
    }
}

