/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.doubleproblem.impl;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;
import org.uma.jmetal.problem.AbstractGenericProblem;
import org.uma.jmetal.problem.doubleproblem.DoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.solution.doublesolution.impl.DefaultDoubleSolution;
import org.uma.jmetal.util.bounds.Bounds;
import org.uma.jmetal.util.errorchecking.Check;

public abstract class AbstractDoubleProblem
extends AbstractGenericProblem<DoubleSolution>
implements DoubleProblem {
    protected List<Bounds<Double>> bounds;

    @Deprecated
    public List<Pair<Double, Double>> getVariableBounds() {
        return this.bounds.stream().map(Bounds::toPair).collect(Collectors.toList());
    }

    @Override
    @Deprecated
    public Double getUpperBound(int index) {
        return this.getBoundsForVariables().get(index).getUpperBound();
    }

    @Override
    @Deprecated
    public Double getLowerBound(int index) {
        return this.getBoundsForVariables().get(index).getLowerBound();
    }

    public void setVariableBounds(List<Double> lowerBounds, List<Double> upperBounds) {
        Check.notNull(lowerBounds);
        Check.notNull(upperBounds);
        Check.that(lowerBounds.size() == upperBounds.size(), "The size of the lower bound list is not equal to the size of the upper bound list");
        this.bounds = IntStream.range(0, lowerBounds.size()).mapToObj(i -> Bounds.create((Double)lowerBounds.get(i), (Double)upperBounds.get(i))).collect(Collectors.toList());
    }

    @Override
    public DoubleSolution createSolution() {
        return new DefaultDoubleSolution(this.getNumberOfObjectives(), this.getNumberOfConstraints(), this.bounds);
    }

    @Override
    @Deprecated
    public List<Pair<Double, Double>> getBounds() {
        return this.getVariableBounds();
    }

    @Override
    public List<Bounds<Double>> getBoundsForVariables() {
        return this.bounds;
    }
}

