/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.doubleproblem.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;
import org.uma.jmetal.problem.doubleproblem.DoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.solution.doublesolution.impl.DefaultDoubleSolution;
import org.uma.jmetal.util.bounds.Bounds;

public class ComposableDoubleProblem
implements DoubleProblem {
    private List<Function<Double[], Double>> objectiveFunctions = new ArrayList<Function<Double[], Double>>();
    private List<Function<Double[], Double>> constraints = new ArrayList<Function<Double[], Double>>();
    private List<Bounds<Double>> bounds = new ArrayList<Bounds<Double>>();
    private String name = "";

    public ComposableDoubleProblem addFunction(Function<Double[], Double> objective) {
        this.objectiveFunctions.add(objective);
        return this;
    }

    public ComposableDoubleProblem addConstraint(Function<Double[], Double> constraint) {
        this.constraints.add(constraint);
        return this;
    }

    public ComposableDoubleProblem addVariable(double lowerBound, double upperBound) {
        this.bounds.add(Bounds.create(lowerBound, upperBound));
        return this;
    }

    public ComposableDoubleProblem setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public int getNumberOfVariables() {
        return this.bounds.size();
    }

    @Override
    public int getNumberOfObjectives() {
        return this.objectiveFunctions.size();
    }

    @Override
    public int getNumberOfConstraints() {
        return this.constraints.size();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Deprecated
    public Double getLowerBound(int index) {
        return this.bounds.get(index).getLowerBound();
    }

    @Override
    @Deprecated
    public Double getUpperBound(int index) {
        return this.bounds.get(index).getUpperBound();
    }

    @Override
    public DoubleSolution createSolution() {
        return new DefaultDoubleSolution(this.getNumberOfObjectives(), this.getNumberOfConstraints(), this.bounds);
    }

    @Override
    @Deprecated
    public List<Pair<Double, Double>> getBounds() {
        return this.bounds.stream().map(Bounds::toPair).collect(Collectors.toList());
    }

    @Override
    public List<Bounds<Double>> getBoundsForVariables() {
        return this.bounds;
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        Double[] vars = solution.variables().toArray(new Double[this.getNumberOfVariables()]);
        IntStream.range(0, this.getNumberOfObjectives()).forEach(i -> {
            solution.objectives()[i] = this.objectiveFunctions.get(i).apply(vars);
        });
        IntStream.range(0, this.getNumberOfConstraints()).forEach(i -> {
            solution.constraints()[i] = this.constraints.get(i).apply(vars);
        });
        return solution;
    }
}

