/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective;

import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class Binh2
extends AbstractDoubleProblem {
    public Binh2() {
        this.setNumberOfVariables(2);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(2);
        this.setName("Binh2");
        List<Double> lowerLimit = Arrays.asList(0.0, 0.0);
        List<Double> upperLimit = Arrays.asList(5.0, 3.0);
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        double[] fx = new double[solution.objectives().length];
        double[] x = new double[this.getNumberOfVariables()];
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            x[i] = (Double)solution.variables().get(i);
        }
        fx[0] = 4.0 * x[0] * x[0] + 4.0 * x[1] * x[1];
        fx[1] = (x[0] - 5.0) * (x[0] - 5.0) + (x[1] - 5.0) * (x[1] - 5.0);
        solution.objectives()[0] = fx[0];
        solution.objectives()[1] = fx[1];
        this.evaluateConstraints(solution);
        return solution;
    }

    public void evaluateConstraints(DoubleSolution solution) {
        double x0 = (Double)solution.variables().get(0);
        double x1 = (Double)solution.variables().get(1);
        solution.constraints()[0] = -1.0 * (x0 - 5.0) * (x0 - 5.0) - x1 * x1 + 25.0;
        solution.constraints()[1] = (x0 - 8.0) * (x0 - 8.0) + (x1 + 3.0) * (x1 + 3.0) - 7.7;
    }
}

