/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.problem.AbstractGenericProblem;
import org.uma.jmetal.solution.compositesolution.CompositeSolution;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.solution.doublesolution.impl.DefaultDoubleSolution;
import org.uma.jmetal.solution.integersolution.IntegerSolution;
import org.uma.jmetal.solution.integersolution.impl.DefaultIntegerSolution;
import org.uma.jmetal.util.bounds.Bounds;

public class MixedIntegerDoubleProblem
extends AbstractGenericProblem<CompositeSolution> {
    private int valueN;
    private int valueM;
    private List<Bounds<Integer>> integerBounds;
    private List<Bounds<Double>> doubleBounds;

    public MixedIntegerDoubleProblem() {
        this(10, 10, 100, -100, -1000, 1000);
    }

    public MixedIntegerDoubleProblem(int numberOfIntegerVariables, int numberOfDoubleVariables, int n, int m, int lowerBound, int upperBound) {
        int i;
        this.valueN = n;
        this.valueM = m;
        this.setNumberOfVariables(2);
        this.setNumberOfObjectives(2);
        this.setName("MixedIntegerDoubleProblem");
        this.integerBounds = new ArrayList<Bounds<Integer>>(numberOfIntegerVariables);
        this.doubleBounds = new ArrayList<Bounds<Double>>(numberOfDoubleVariables);
        for (i = 0; i < numberOfIntegerVariables; ++i) {
            this.integerBounds.add(Bounds.create(lowerBound, upperBound));
        }
        for (i = 0; i < numberOfDoubleVariables; ++i) {
            this.doubleBounds.add(Bounds.create(Double.valueOf(lowerBound), Double.valueOf(upperBound)));
        }
    }

    @Override
    public CompositeSolution evaluate(CompositeSolution solution) {
        int approximationToN = 0;
        int approximationToM = 0;
        List integerVariables = ((IntegerSolution)solution.variables().get(0)).variables();
        for (int i = 0; i < integerVariables.size(); ++i) {
            approximationToN += Math.abs(this.valueN - (Integer)integerVariables.get(i));
            approximationToM += Math.abs(this.valueM - (Integer)integerVariables.get(i));
        }
        List doubleVariables = ((DoubleSolution)solution.variables().get(1)).variables();
        for (int i = 0; i < doubleVariables.size(); ++i) {
            approximationToN = (int)((double)approximationToN + Math.abs((double)this.valueN - (Double)doubleVariables.get(i)));
            approximationToM = (int)((double)approximationToM + Math.abs((double)this.valueM - (Double)doubleVariables.get(i)));
        }
        solution.objectives()[0] = approximationToN;
        solution.objectives()[1] = approximationToM;
        return solution;
    }

    @Override
    public CompositeSolution createSolution() {
        DefaultIntegerSolution integerSolution = new DefaultIntegerSolution(this.getNumberOfObjectives(), this.getNumberOfConstraints(), this.integerBounds);
        DefaultDoubleSolution doubleSolution = new DefaultDoubleSolution(this.getNumberOfObjectives(), this.getNumberOfConstraints(), this.doubleBounds);
        return new CompositeSolution(Arrays.asList(integerSolution, doubleSolution));
    }
}

