/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import org.uma.jmetal.problem.permutationproblem.impl.AbstractIntegerPermutationProblem;
import org.uma.jmetal.solution.permutationsolution.PermutationSolution;
import org.uma.jmetal.util.errorchecking.JMetalException;

public class MultiobjectiveTSP
extends AbstractIntegerPermutationProblem {
    protected int numberOfCities;
    protected double[][] distanceMatrix;
    protected double[][] costMatrix;

    public MultiobjectiveTSP(String distanceFile, String costFile) throws IOException {
        this.distanceMatrix = this.readProblem(distanceFile);
        this.costMatrix = this.readProblem(costFile);
        this.setNumberOfVariables(this.numberOfCities);
        this.setNumberOfObjectives(2);
        this.setName("MultiobjectiveTSP");
    }

    @Override
    public PermutationSolution<Integer> evaluate(PermutationSolution<Integer> solution) {
        double fitness1 = 0.0;
        double fitness2 = 0.0;
        for (int i = 0; i < this.numberOfCities - 1; ++i) {
            int x = (Integer)solution.variables().get(i);
            int y = (Integer)solution.variables().get(i + 1);
            fitness1 += this.distanceMatrix[x][y];
            fitness2 += this.costMatrix[x][y];
        }
        int firstCity = (Integer)solution.variables().get(0);
        int lastCity = (Integer)solution.variables().get(this.numberOfCities - 1);
        solution.objectives()[0] = fitness1 += this.distanceMatrix[firstCity][lastCity];
        solution.objectives()[1] = fitness2 += this.costMatrix[firstCity][lastCity];
        return solution;
    }

    private double[][] readProblem(String file) throws IOException {
        double[][] matrix = null;
        InputStream in = this.getClass().getResourceAsStream(file);
        if (in == null) {
            in = new FileInputStream(file);
        }
        InputStreamReader isr = new InputStreamReader(in);
        BufferedReader br = new BufferedReader(isr);
        StreamTokenizer token = new StreamTokenizer(br);
        try {
            boolean found = false;
            token.nextToken();
            while (!found) {
                if (token.sval != null && token.sval.compareTo("DIMENSION") == 0) {
                    found = true;
                    continue;
                }
                token.nextToken();
            }
            token.nextToken();
            token.nextToken();
            this.numberOfCities = (int)token.nval;
            matrix = new double[this.numberOfCities][this.numberOfCities];
            found = false;
            token.nextToken();
            while (!found) {
                if (token.sval != null && token.sval.compareTo("SECTION") == 0) {
                    found = true;
                    continue;
                }
                token.nextToken();
            }
            double[] c = new double[2 * this.numberOfCities];
            for (int i = 0; i < this.numberOfCities; ++i) {
                token.nextToken();
                int j = (int)token.nval;
                token.nextToken();
                c[2 * (j - 1)] = token.nval;
                token.nextToken();
                c[2 * (j - 1) + 1] = token.nval;
            }
            for (int k = 0; k < this.numberOfCities; ++k) {
                matrix[k][k] = 0.0;
                for (int j = k + 1; j < this.numberOfCities; ++j) {
                    double dist = Math.sqrt(Math.pow(c[k * 2] - c[j * 2], 2.0) + Math.pow(c[k * 2 + 1] - c[j * 2 + 1], 2.0));
                    matrix[k][j] = dist = (double)((int)(dist + 0.5));
                    matrix[j][k] = dist;
                }
            }
        }
        catch (Exception e) {
            throw new JMetalException("TSP.readProblem(): error when reading data file " + e);
        }
        return matrix;
    }

    @Override
    public int getLength() {
        return this.numberOfCities;
    }
}

