/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.UF;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class UF7
extends AbstractDoubleProblem {
    public UF7() {
        this(30);
    }

    public UF7(int numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(0);
        this.setName("UF7");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        lowerLimit.add(0.0);
        upperLimit.add(1.0);
        for (int i = 1; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-1.0);
            upperLimit.add(1.0);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        double yj;
        double[] x = new double[this.getNumberOfVariables()];
        for (int i = 0; i < solution.variables().size(); ++i) {
            x[i] = (Double)solution.variables().get(i);
        }
        double sum2 = 0.0;
        double sum1 = 0.0;
        int count2 = 0;
        int count1 = 0;
        for (int j = 2; j <= this.getNumberOfVariables(); ++j) {
            yj = x[j - 1] - Math.sin(Math.PI * 6 * x[0] + (double)j * Math.PI / (double)this.getNumberOfVariables());
            if (j % 2 == 0) {
                sum2 += yj * yj;
                ++count2;
                continue;
            }
            sum1 += yj * yj;
            ++count1;
        }
        yj = Math.pow(x[0], 0.2);
        solution.objectives()[0] = yj + 2.0 * sum1 / (double)count1;
        solution.objectives()[1] = 1.0 - yj + 2.0 * sum2 / (double)count2;
        return solution;
    }
}

