/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.UF;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class UF8
extends AbstractDoubleProblem {
    public UF8() {
        this(30);
    }

    public UF8(int numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(3);
        this.setNumberOfConstraints(0);
        this.setName("UF8");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        lowerLimit.add(0.0);
        upperLimit.add(1.0);
        lowerLimit.add(0.0);
        upperLimit.add(1.0);
        for (int i = 2; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-2.0);
            upperLimit.add(2.0);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        double[] x = new double[this.getNumberOfVariables()];
        for (int i = 0; i < solution.variables().size(); ++i) {
            x[i] = (Double)solution.variables().get(i);
        }
        double sum3 = 0.0;
        double sum2 = 0.0;
        double sum1 = 0.0;
        int count3 = 0;
        int count2 = 0;
        int count1 = 0;
        for (int j = 3; j <= this.getNumberOfVariables(); ++j) {
            double yj = x[j - 1] - 2.0 * x[1] * Math.sin(Math.PI * 2 * x[0] + (double)j * Math.PI / (double)this.getNumberOfVariables());
            if (j % 3 == 1) {
                sum1 += yj * yj;
                ++count1;
                continue;
            }
            if (j % 3 == 2) {
                sum2 += yj * yj;
                ++count2;
                continue;
            }
            sum3 += yj * yj;
            ++count3;
        }
        solution.objectives()[0] = Math.cos(1.5707963267948966 * x[0]) * Math.cos(1.5707963267948966 * x[1]) + 2.0 * sum1 / (double)count1;
        solution.objectives()[1] = Math.cos(1.5707963267948966 * x[0]) * Math.sin(1.5707963267948966 * x[1]) + 2.0 * sum2 / (double)count2;
        solution.objectives()[2] = Math.sin(1.5707963267948966 * x[0]) + 2.0 * sum3 / (double)count3;
        return solution;
    }
}

