/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.cdtlz;

import org.uma.jmetal.problem.multiobjective.dtlz.DTLZ2;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class C2_DTLZ2
extends DTLZ2 {
    private double rValue;

    public C2_DTLZ2(int numberOfVariables, int numberOfObjectives) {
        super(numberOfVariables, numberOfObjectives);
        this.setNumberOfConstraints(1);
        this.rValue = this.getNumberOfObjectives() == 3 ? 0.4 : 0.5;
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        super.evaluate(solution);
        this.evaluateConstraints(solution);
        return solution;
    }

    public void evaluateConstraints(DoubleSolution solution) {
        double sum2 = 0.0;
        double maxSum1 = Double.MIN_VALUE;
        for (int i = 0; i < solution.objectives().length; ++i) {
            double sum1 = Math.pow(solution.objectives()[i] - 1.0, 2.0) - Math.pow(this.rValue, 2.0);
            for (int j = 0; j < solution.objectives().length; ++j) {
                if (i == j) continue;
                sum1 += Math.pow(solution.objectives()[j], 2.0);
            }
            maxSum1 = Math.max(maxSum1, sum1);
            sum2 += Math.pow(solution.objectives()[i] - 1.0 / Math.sqrt(solution.objectives().length), 2.0);
        }
        solution.constraints()[0] = Math.max(maxSum1, sum2 -= Math.pow(this.rValue, 2.0));
    }
}

