/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.cdtlz;

import org.uma.jmetal.problem.multiobjective.dtlz.DTLZ1;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class C3_DTLZ1
extends DTLZ1 {
    public C3_DTLZ1(int numberOfVariables, int numberOfObjectives, int numberOfConstraints) {
        super(numberOfVariables, numberOfObjectives);
        this.setNumberOfConstraints(numberOfConstraints);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        super.evaluate(solution);
        this.evaluateConstraints(solution);
        return solution;
    }

    public void evaluateConstraints(DoubleSolution solution) {
        double[] constraint = new double[this.getNumberOfConstraints()];
        for (int j = 0; j < this.getNumberOfConstraints(); ++j) {
            double sum = 0.0;
            constraint[j] = 0.0;
            for (int i = 0; i < solution.objectives().length; ++i) {
                if (i != j) {
                    sum += solution.objectives()[j];
                }
                int n = j;
                constraint[n] = constraint[n] + (sum + solution.objectives()[i] / 0.5 - 1.0);
            }
        }
        for (int i = 0; i < this.getNumberOfConstraints(); ++i) {
            solution.constraints()[i] = constraint[i];
        }
    }
}

