/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.cdtlz;

import org.uma.jmetal.problem.multiobjective.dtlz.DTLZ4;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class C3_DTLZ4
extends DTLZ4 {
    public C3_DTLZ4(int numberOfVariables, int numberOfObjectives, int numberOfConstraints) {
        super(numberOfVariables, numberOfObjectives);
        this.setNumberOfConstraints(numberOfConstraints);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        super.evaluate(solution);
        this.evaluateConstraints(solution);
        return solution;
    }

    public void evaluateConstraints(DoubleSolution solution) {
        double[] constraint = new double[this.getNumberOfConstraints()];
        for (int j = 0; j < this.getNumberOfConstraints(); ++j) {
            double sum = 0.0;
            constraint[j] = Math.pow(solution.objectives()[j], 2.0) / 4.0 - 1.0;
            for (int i = 0; i < solution.objectives().length; ++i) {
                if (i != j) {
                    sum += Math.pow(solution.objectives()[j], 2.0);
                }
                int n = j;
                constraint[n] = constraint[n] + sum;
            }
        }
        for (int i = 0; i < this.getNumberOfConstraints(); ++i) {
            solution.constraints()[i] = constraint[i];
        }
    }
}

