/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.cre;

import java.util.List;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class CRE21
extends AbstractDoubleProblem {
    public CRE21() {
        this.setNumberOfVariables(3);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(3);
        this.setName("CRE21");
        List<Double> lowerLimit = List.of(Double.valueOf(0.01), Double.valueOf(0.01), Double.valueOf(0.01));
        List<Double> upperLimit = List.of(Double.valueOf(0.45), Double.valueOf(0.1), Double.valueOf(0.1));
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        double x1 = (Double)solution.variables().get(0);
        double x2 = (Double)solution.variables().get(1);
        double x3 = (Double)solution.variables().get(2);
        solution.objectives()[0] = x1 * Math.sqrt(16.0 + x3 * x3) + x2 * Math.sqrt(1.0 + x3 * x3);
        solution.objectives()[1] = 20.0 * Math.sqrt(16.0 + x3 * x3) / (x1 * x3);
        this.evaluateConstraints(solution);
        return solution;
    }

    public void evaluateConstraints(DoubleSolution solution) {
        int i;
        double[] constraint = new double[this.getNumberOfConstraints()];
        double x2 = (Double)solution.variables().get(1);
        double x3 = (Double)solution.variables().get(2);
        constraint[0] = 0.1 - solution.objectives()[0];
        constraint[1] = 100000.0 - -solution.objectives()[1];
        constraint[2] = 100000.0 - 80.0 * Math.sqrt(1.0 + x3 * x3) / (x3 * x2);
        for (i = 0; i < this.getNumberOfConstraints(); ++i) {
            constraint[i] = constraint[i] < 0.0 ? -constraint[i] : 0.0;
        }
        for (i = 0; i < this.getNumberOfConstraints(); ++i) {
            solution.constraints()[i] = constraint[i];
        }
    }
}

