/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.cre;

import java.util.List;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class CRE22
extends AbstractDoubleProblem {
    private double P = 6000.0;
    private double L = 14.0;
    private double E = 3.0E7;

    public CRE22() {
        this.setNumberOfVariables(4);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(4);
        this.setName("CRE22");
        List<Double> lowerLimit = List.of(Double.valueOf(0.125), Double.valueOf(0.1), Double.valueOf(0.1), Double.valueOf(0.125));
        List<Double> upperLimit = List.of(Double.valueOf(5.0), Double.valueOf(10.0), Double.valueOf(10.0), Double.valueOf(5.0));
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        double x1 = (Double)solution.variables().get(0);
        double x2 = (Double)solution.variables().get(1);
        double x3 = (Double)solution.variables().get(2);
        double x4 = (Double)solution.variables().get(3);
        solution.objectives()[0] = 1.10471 * x1 * x1 * x2 + 0.04811 * x3 * x4 * (14.0 + x2);
        solution.objectives()[1] = 4.0 * this.P * this.L * this.L * this.L / (this.E * x4 * x3 * x3 * x3);
        this.evaluateConstraints(solution);
        return solution;
    }

    public void evaluateConstraints(DoubleSolution solution) {
        int i;
        double[] constraint = new double[this.getNumberOfConstraints()];
        double x1 = (Double)solution.variables().get(0);
        double x2 = (Double)solution.variables().get(1);
        double x3 = (Double)solution.variables().get(2);
        double x4 = (Double)solution.variables().get(3);
        double G = 1.2E7;
        double tauMax = 13600.0;
        double sigmaMax = 30000.0;
        double M = this.P * (this.L + x2 / 2.0);
        double tmpVar = x2 * x2 / 4.0 + Math.pow((x1 + x3) / 2.0, 2.0);
        double R = Math.sqrt(tmpVar);
        tmpVar = x2 * x2 / 12.0 + Math.pow((x1 + x3) / 2.0, 2.0);
        double J = 2.0 * Math.sqrt(2.0) * x1 * x2 * tmpVar;
        double tauDashDash = M * R / J;
        double tauDash = this.P / (Math.sqrt(2.0) * x1 * x2);
        tmpVar = tauDash * tauDash + 2.0 * tauDash * tauDashDash * x2 / (2.0 * R) + tauDashDash * tauDashDash;
        double tau = Math.sqrt(tmpVar);
        double sigma = 6.0 * this.P * this.L / (x4 * x3 * x3);
        tmpVar = 4.013 * this.E * Math.sqrt(x3 * x3 * x4 * x4 * x4 * x4 * x4 * x4 / 36.0) / (this.L * this.L);
        double tmpVar2 = x3 / (2.0 * this.L) * Math.sqrt(this.E / (4.0 * G));
        double PC = tmpVar * (1.0 - tmpVar2);
        constraint[0] = tauMax - tau;
        constraint[1] = sigmaMax - sigma;
        constraint[2] = x4 - x1;
        constraint[3] = PC - this.P;
        for (i = 0; i < this.getNumberOfConstraints(); ++i) {
            constraint[i] = constraint[i] < 0.0 ? -constraint[i] : 0.0;
        }
        for (i = 0; i < this.getNumberOfConstraints(); ++i) {
            solution.constraints()[i] = constraint[i];
        }
    }
}

