/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.cre;

import java.util.List;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class CRE23
extends AbstractDoubleProblem {
    public CRE23() {
        this.setNumberOfVariables(4);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(4);
        this.setName("CRE23");
        List<Double> lowerLimit = List.of(Double.valueOf(55.0), Double.valueOf(75.0), Double.valueOf(1000.0), Double.valueOf(11.0));
        List<Double> upperLimit = List.of(Double.valueOf(80.0), Double.valueOf(110.0), Double.valueOf(3000.0), Double.valueOf(20.0));
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        double x1 = (Double)solution.variables().get(0);
        double x2 = (Double)solution.variables().get(1);
        double x3 = (Double)solution.variables().get(2);
        double x4 = (Double)solution.variables().get(3);
        solution.objectives()[0] = 4.9000000000000005E-5 * (x2 * x2 - x1 * x1) * (x4 - 1.0);
        solution.objectives()[1] = 9820000.0 * (x2 * x2 - x1 * x1) / (x3 * x4 * (x2 * x2 * x2 - x1 * x1 * x1));
        this.evaluateConstraints(solution);
        return solution;
    }

    public void evaluateConstraints(DoubleSolution solution) {
        int i;
        double[] constraint = new double[this.getNumberOfConstraints()];
        double x1 = (Double)solution.variables().get(0);
        double x2 = (Double)solution.variables().get(1);
        double x3 = (Double)solution.variables().get(2);
        double x4 = (Double)solution.variables().get(3);
        constraint[0] = x2 - x1 - 20.0;
        constraint[1] = 0.4 - x3 / (3.14 * (x2 * x2 - x1 * x1));
        constraint[2] = 1.0 - 0.00222 * x3 * (x2 * x2 * x2 - x1 * x1 * x1) / Math.pow(x2 * x2 - x1 * x1, 2.0);
        constraint[3] = 0.026600000000000002 * x3 * x4 * (x2 * x2 * x2 - x1 * x1 * x1) / (x2 * x2 - x1 * x1) - 900.0;
        for (i = 0; i < this.getNumberOfConstraints(); ++i) {
            constraint[i] = constraint[i] < 0.0 ? -constraint[i] : 0.0;
        }
        for (i = 0; i < this.getNumberOfConstraints(); ++i) {
            solution.constraints()[i] = constraint[i];
        }
    }
}

