/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.cre;

import java.util.List;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class CRE24
extends AbstractDoubleProblem {
    public CRE24() {
        this.setNumberOfVariables(7);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(11);
        this.setName("CRE24");
        List<Double> lowerLimit = List.of(Double.valueOf(2.6), Double.valueOf(0.7), Double.valueOf(17.0), Double.valueOf(7.3), Double.valueOf(7.3), Double.valueOf(2.9), Double.valueOf(5.0));
        List<Double> upperLimit = List.of(Double.valueOf(3.6), Double.valueOf(0.8), Double.valueOf(28.0), Double.valueOf(8.3), Double.valueOf(8.3), Double.valueOf(3.9), Double.valueOf(5.5));
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        double x1 = (Double)solution.variables().get(0);
        double x2 = (Double)solution.variables().get(1);
        double x3 = Math.rint((Double)solution.variables().get(2));
        double x4 = (Double)solution.variables().get(3);
        double x5 = (Double)solution.variables().get(4);
        double x6 = (Double)solution.variables().get(5);
        double x7 = (Double)solution.variables().get(6);
        solution.objectives()[0] = 0.7854 * x1 * (x2 * x2) * (10.0 * x3 * x3 / 3.0 + 14.933 * x3 - 43.0934) - 1.508 * x1 * (x6 * x6 + x7 * x7) + 7.477 * (x6 * x6 * x6 + x7 * x7 * x7) + 0.7854 * (x4 * x6 * x6 + x5 * x7 * x7);
        double tmpVar = Math.pow(745.0 * x4 / (x2 * x3), 2.0) + 1.69E7;
        solution.objectives()[1] = Math.sqrt(tmpVar) / (0.1 * x6 * x6 * x6);
        this.evaluateConstraints(solution);
        return solution;
    }

    public void evaluateConstraints(DoubleSolution solution) {
        int i;
        double[] constraint = new double[this.getNumberOfConstraints()];
        double x1 = (Double)solution.variables().get(0);
        double x2 = (Double)solution.variables().get(1);
        double x3 = Math.rint((Double)solution.variables().get(2));
        double x4 = (Double)solution.variables().get(3);
        double x5 = (Double)solution.variables().get(4);
        double x6 = (Double)solution.variables().get(5);
        double x7 = (Double)solution.variables().get(6);
        constraint[0] = -(1.0 / (x1 * x2 * x2 * x3)) + 0.037037037037037035;
        constraint[1] = -(1.0 / (x1 * x2 * x2 * x3 * x3)) + 0.0025157232704402514;
        constraint[2] = -(x4 * x4 * x4) / (x2 * x3 * x6 * x6 * x6 * x6) + 0.5181347150259068;
        constraint[3] = -(x5 * x5 * x5) / (x2 * x3 * x7 * x7 * x7 * x7) + 0.5181347150259068;
        constraint[4] = -(x2 * x3) + 40.0;
        constraint[5] = -(x1 / x2) + 12.0;
        constraint[6] = -5.0 + x1 / x2;
        constraint[7] = -1.9 + x4 - 1.5 * x6;
        constraint[8] = -1.9 + x5 - 1.1 * x7;
        constraint[9] = -solution.objectives()[1] + 1300.0;
        double tmpVar = Math.pow(745.0 * x5 / (x2 * x3), 2.0) + 1.575E8;
        constraint[10] = -Math.sqrt(tmpVar) / (0.1 * x7 * x7 * x7) + 1100.0;
        for (i = 0; i < this.getNumberOfConstraints(); ++i) {
            constraint[i] = constraint[i] < 0.0 ? -constraint[i] : 0.0;
        }
        for (i = 0; i < this.getNumberOfConstraints(); ++i) {
            solution.constraints()[i] = constraint[i];
        }
    }
}

