/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.cre;

import java.util.List;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class CRE25
extends AbstractDoubleProblem {
    public CRE25() {
        this.setNumberOfVariables(4);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(1);
        this.setName("CRE25");
        List<Double> lowerLimit = List.of(Double.valueOf(12.0), Double.valueOf(12.0), Double.valueOf(12.0), Double.valueOf(12.0));
        List<Double> upperLimit = List.of(Double.valueOf(60.0), Double.valueOf(60.0), Double.valueOf(60.0), Double.valueOf(60.0));
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        double x1 = Math.rint((Double)solution.variables().get(0));
        double x2 = Math.rint((Double)solution.variables().get(1));
        double x3 = Math.rint((Double)solution.variables().get(2));
        double x4 = Math.rint((Double)solution.variables().get(3));
        solution.objectives()[0] = Math.abs(6.931 - x3 / x1 * (x4 / x2));
        double maxValue = x1;
        if (x2 > maxValue) {
            maxValue = x2;
        }
        if (x3 > maxValue) {
            maxValue = x3;
        }
        if (x4 > maxValue) {
            maxValue = x4;
        }
        solution.objectives()[1] = maxValue;
        this.evaluateConstraints(solution);
        return solution;
    }

    public void evaluateConstraints(DoubleSolution solution) {
        double constraint = 0.5 - solution.objectives()[1] / 6.931;
        constraint = constraint < 0.0 ? -constraint : 0.0;
        solution.constraints()[0] = constraint;
    }
}

