/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.cre;

import java.util.List;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class CRE51
extends AbstractDoubleProblem {
    public CRE51() {
        this.setNumberOfVariables(3);
        this.setNumberOfObjectives(5);
        this.setNumberOfConstraints(7);
        this.setName("CRE51");
        List<Double> lowerLimit = List.of(Double.valueOf(0.01), Double.valueOf(0.01), Double.valueOf(0.01));
        List<Double> upperLimit = List.of(Double.valueOf(0.45), Double.valueOf(0.1), Double.valueOf(0.1));
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        double[] x = new double[this.getNumberOfVariables()];
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            x[i] = (Double)solution.variables().get(i);
        }
        solution.objectives()[0] = 106780.37 * (x[1] + x[2]) + 61704.67;
        solution.objectives()[1] = 3000.0 * x[0];
        solution.objectives()[2] = 6.997473E8 * x[1] / Math.pow(137.34, 0.65);
        solution.objectives()[3] = 572250.0 * Math.exp(-39.75 * x[1] + 9.9 * x[2] + 2.74);
        solution.objectives()[4] = 25.0 * (1.39 / (x[0] * x[1]) + 4940.0 * x[2] - 80.0);
        this.evaluateConstraints(solution, x);
        return solution;
    }

    public void evaluateConstraints(DoubleSolution solution, double[] x) {
        int i;
        double[] constraint = new double[this.getNumberOfConstraints()];
        constraint[0] = 1.0 - (0.00139 / (x[0] * x[1]) + 4.94 * x[2] - 0.08);
        constraint[1] = 1.0 - (3.06E-4 / (x[0] * x[1]) + 1.082 * x[2] - 0.0986);
        constraint[2] = 50000.0 - (12.307 / (x[0] * x[1]) + 49408.24 * x[2] + 4051.02);
        constraint[3] = 16000.0 - (2.098 / (x[0] * x[1]) + 8046.33 * x[2] - 696.71);
        constraint[4] = 10000.0 - (2.138 / (x[0] * x[1]) + 7883.39 * x[2] - 705.04);
        constraint[5] = 2000.0 - (0.417 * x[0] * x[1] + 1721.26 * x[2] - 136.54);
        constraint[6] = 550.0 - (0.164 / (x[0] * x[1]) + 631.13 * x[2] - 54.48);
        for (i = 0; i < this.getNumberOfConstraints(); ++i) {
            constraint[i] = constraint[i] < 0.0 ? -constraint[i] : 0.0;
        }
        for (i = 0; i < this.getNumberOfConstraints(); ++i) {
            solution.constraints()[i] = constraint[i];
        }
    }
}

