/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.dtlz;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.errorchecking.JMetalException;

public class DTLZ2
extends AbstractDoubleProblem {
    public DTLZ2() {
        this(12, 3);
    }

    public DTLZ2(Integer numberOfVariables, Integer numberOfObjectives) throws JMetalException {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(numberOfObjectives);
        this.setName("DTLZ2");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(0.0);
            upperLimit.add(1.0);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        int i;
        int numberOfVariables = this.getNumberOfVariables();
        int numberOfObjectives = solution.objectives().length;
        double[] f = new double[numberOfObjectives];
        double[] x = new double[numberOfVariables];
        for (int i2 = 0; i2 < numberOfVariables; ++i2) {
            x[i2] = (Double)solution.variables().get(i2);
        }
        int k = this.getNumberOfVariables() - solution.objectives().length + 1;
        double g = 0.0;
        for (i = numberOfVariables - k; i < numberOfVariables; ++i) {
            g += (x[i] - 0.5) * (x[i] - 0.5);
        }
        for (i = 0; i < numberOfObjectives; ++i) {
            f[i] = 1.0 + g;
        }
        for (i = 0; i < numberOfObjectives; ++i) {
            for (int j = 0; j < numberOfObjectives - (i + 1); ++j) {
                int n = i;
                f[n] = f[n] * Math.cos(x[j] * 0.5 * Math.PI);
            }
            if (i == 0) continue;
            int aux = numberOfObjectives - (i + 1);
            int n = i;
            f[n] = f[n] * Math.sin(x[aux] * 0.5 * Math.PI);
        }
        for (i = 0; i < numberOfObjectives; ++i) {
            solution.objectives()[i] = f[i];
        }
        return solution;
    }
}

