/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.fda;

import java.util.ArrayList;
import org.uma.jmetal.problem.multiobjective.fda.FDA;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.observable.Observable;
import org.uma.jmetal.util.observable.impl.DefaultObservable;

public class FDA1
extends FDA {
    public FDA1(Observable<Integer> observable) {
        this(100, 2);
    }

    public FDA1() {
        this(new DefaultObservable<Integer>("FDA1 observable"));
    }

    public FDA1(Integer numberOfVariables, Integer numberOfObjectives) throws JMetalException {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(numberOfObjectives);
        this.setName("FDA1");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        lowerLimit.add(0.0);
        upperLimit.add(1.0);
        for (int i = 1; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-1.0);
            upperLimit.add(1.0);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        double[] f = new double[solution.objectives().length];
        f[0] = (Double)solution.variables().get(0);
        double g = this.evalG(solution);
        double h = this.evalH(f[0], g);
        f[1] = h * g;
        solution.objectives()[0] = f[0];
        solution.objectives()[1] = f[1];
        return solution;
    }

    private double evalG(DoubleSolution solution) {
        double gT = Math.sin(1.5707963267948966 * this.time);
        double g = 0.0;
        for (int i = 1; i < solution.variables().size(); ++i) {
            g += Math.pow((Double)solution.variables().get(i) - gT, 2.0);
        }
        return g += 1.0;
    }

    public double evalH(double f, double g) {
        double h = 1.0 - Math.sqrt(f / g);
        return h;
    }
}

