/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.fda;

import java.io.Serializable;
import java.util.ArrayList;
import org.uma.jmetal.problem.multiobjective.fda.FDA;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class FDA2
extends FDA
implements Serializable {
    public FDA2() {
        this(31, 2);
    }

    public FDA2(Integer numberOfVariables, Integer numberOfObjectives) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(numberOfObjectives);
        this.setName("FDA2");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        lowerLimit.add(0.0);
        upperLimit.add(1.0);
        for (int i = 1; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-1.0);
            upperLimit.add(1.0);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        double[] f = new double[solution.objectives().length];
        f[0] = (Double)solution.variables().get(0);
        double g = this.evalG(solution, 1, solution.variables().size() / 2 + 1);
        double h = this.evalH(f[0], g);
        f[1] = g * h;
        solution.objectives()[0] = f[0];
        solution.objectives()[1] = f[1];
        return solution;
    }

    private double evalG(DoubleSolution solution, int limitInf, int limitSup) {
        int i;
        double g = 0.0;
        for (i = limitInf; i < limitSup; ++i) {
            g += Math.pow((Double)solution.variables().get(i), 2.0);
        }
        for (i = limitSup; i < solution.variables().size(); ++i) {
            g += Math.pow((Double)solution.variables().get(i) + 1.0, 2.0);
        }
        return g += 1.0;
    }

    private double evalH(double f, double g) {
        double HT = 0.2 + 4.8 * Math.pow(this.time, 2.0);
        double h = 1.0 - Math.pow(f / g, HT);
        return h;
    }
}

