/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.fda;

import java.io.Serializable;
import java.util.ArrayList;
import org.uma.jmetal.problem.multiobjective.fda.FDA;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.errorchecking.JMetalException;

public class FDA3
extends FDA
implements Serializable {
    private final int limitInfI = 0;
    private final int limitSupI = 1;
    private final int limitInfII = 1;

    public FDA3() {
        this(30, 2);
    }

    public FDA3(Integer numberOfVariables, Integer numberOfObjectives) throws JMetalException {
        int i;
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(numberOfObjectives);
        this.setName("FDA3");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (i = 0; i < 1; ++i) {
            lowerLimit.add(0.0);
            upperLimit.add(1.0);
        }
        for (i = 1; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-1.0);
            upperLimit.add(1.0);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        double[] f = new double[solution.objectives().length];
        f[0] = this.evalF(solution, 0, 1);
        double g = this.evalG(solution, 1);
        double h = this.evalH(f[0], g);
        f[1] = g * h;
        solution.objectives()[0] = f[0];
        solution.objectives()[1] = f[1];
        return solution;
    }

    private double evalF(DoubleSolution solution, int limitInf, int limitSup) {
        double f = 0.0;
        double aux = 2.0 * Math.sin(1.5707963267948966 * this.time);
        double Ft = Math.pow(10.0, aux);
        for (int i = limitInf; i < limitSup; ++i) {
            f += Math.pow((Double)solution.variables().get(i), Ft);
        }
        return f;
    }

    private double evalG(DoubleSolution solution, int limitInf) {
        double g = 0.0;
        double Gt = Math.abs(Math.sin(1.5707963267948966 * this.time));
        for (int i = limitInf; i < solution.variables().size(); ++i) {
            g += Math.pow((Double)solution.variables().get(i) - Gt, 2.0);
        }
        g = g + 1.0 + Gt;
        return g;
    }

    private double evalH(double f, double g) {
        double h = 1.0 - Math.sqrt(f / g);
        return h;
    }
}

