/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.glt;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class GLT3
extends AbstractDoubleProblem {
    public GLT3() {
        this(10);
    }

    public GLT3(int numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(2);
        this.setName("GLT3");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        lowerLimit.add(0.0);
        upperLimit.add(1.0);
        for (int i = 1; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-1.0);
            upperLimit.add(1.0);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        solution.objectives()[0] = (1.0 + this.g(solution)) * solution.objectives()[0];
        solution.objectives()[1] = solution.objectives()[0] < 0.05 ? (1.0 + this.g(solution)) * (1.0 - 19.0 * solution.objectives()[0]) : (1.0 + this.g(solution)) * (0.05263157894736842 - solution.objectives()[0] / 19.0);
        return solution;
    }

    private double g(DoubleSolution solution) {
        double result = 0.0;
        for (int i = 1; i < solution.variables().size(); ++i) {
            double value = solution.objectives()[i] - Math.sin(Math.PI * 2 * solution.objectives()[0] + (double)i * Math.PI / (double)solution.variables().size());
            result += value * value;
        }
        return result;
    }
}

