/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.glt;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class GLT4
extends AbstractDoubleProblem {
    public GLT4() {
        this(10);
    }

    public GLT4(int numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(2);
        this.setName("GLT4");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        lowerLimit.add(0.0);
        upperLimit.add(1.0);
        for (int i = 1; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-1.0);
            upperLimit.add(1.0);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        solution.objectives()[0] = (1.0 + this.g(solution)) * (Double)solution.variables().get(0);
        solution.objectives()[1] = (1.0 + this.g(solution)) * (2.0 - 2.0 * Math.pow((Double)solution.variables().get(0), 0.5) * Math.pow(Math.cos(2.0 * Math.pow((Double)solution.variables().get(0), 0.5) * Math.PI), 2.0));
        return solution;
    }

    private double g(DoubleSolution solution) {
        double result = 0.0;
        for (int i = 1; i < solution.variables().size(); ++i) {
            double value = (Double)solution.variables().get(i) - Math.sin(Math.PI * 2 * (Double)solution.variables().get(0) + (double)i * Math.PI / (double)solution.variables().size());
            result += value * value;
        }
        return result;
    }
}

