/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.lircmop;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class LIRCMOP13
extends AbstractDoubleProblem {
    public LIRCMOP13() {
        this(30);
    }

    public LIRCMOP13(int numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(3);
        this.setNumberOfConstraints(2);
        this.setName("LIRCMOP13");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(0.0);
            upperLimit.add(1.0);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        double[] x = new double[this.getNumberOfVariables()];
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            x[i] = (Double)solution.variables().get(i);
        }
        solution.objectives()[0] = (1.7057 + this.g1(x)) * Math.cos(1.5707963267948966 * x[0]) * Math.cos(1.5707963267948966 + x[1]);
        solution.objectives()[1] = (1.7057 + this.g1(x)) * Math.cos(1.5707963267948966 * x[0]) * Math.sin(1.5707963267948966 + x[1]);
        solution.objectives()[2] = (1.7057 + this.g1(x)) * Math.sin(1.5707963267948966 + x[0]);
        this.evaluateConstraints(solution);
        return solution;
    }

    public void evaluateConstraints(DoubleSolution solution) {
        double[] constraint = new double[this.getNumberOfConstraints()];
        double f = 0.0;
        for (int i = 0; i < solution.objectives().length; ++i) {
            f += Math.pow(solution.objectives()[i], 2.0);
        }
        constraint[0] = (f - 9.0) * (f - 4.0);
        constraint[1] = (f - 3.61) * (f - 3.24);
        solution.constraints()[0] = constraint[0];
        solution.constraints()[1] = constraint[1];
    }

    protected double g1(double[] x) {
        double result = 0.0;
        for (int i = 2; i < this.getNumberOfVariables(); i += 2) {
            result += 10.0 * Math.pow(x[i] - 0.5, 2.0);
        }
        return result;
    }
}

