/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.lircmop;

import org.uma.jmetal.problem.multiobjective.lircmop.LIRCMOP8;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class LIRCMOP9
extends LIRCMOP8 {
    public LIRCMOP9() {
        this(30);
    }

    public LIRCMOP9(int numberOfVariables) {
        super(numberOfVariables);
        this.setName("LIRCMOP9");
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        double[] x = new double[this.getNumberOfVariables()];
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            x[i] = (Double)solution.variables().get(i);
        }
        solution.objectives()[0] = 1.7057 * x[0] * (10.0 * this.g1(x) + 1.0);
        solution.objectives()[1] = 1.7957 * (1.0 - x[0] * x[0]) * (10.0 * this.g2(x) + 1.0);
        this.evaluateConstraints(solution);
        return solution;
    }

    @Override
    public void evaluateConstraints(DoubleSolution solution) {
        double f0 = solution.objectives()[0];
        double f1 = solution.objectives()[1];
        double N = 4.0;
        double theta = -0.7853981633974483;
        double[] constraint = new double[this.getNumberOfConstraints()];
        constraint[0] = f0 * Math.sin(theta) + f1 * Math.cos(theta) - Math.sin(N * Math.PI * (f0 * Math.cos(theta) - f1 * Math.sin(theta))) - 2.0;
        double xOffset = 1.4;
        double yOffset = 1.4;
        double a2 = 1.5;
        double b = 6.0;
        double r = 0.1;
        constraint[1] = Math.pow(((f0 - xOffset) * Math.cos(theta) - (f1 - yOffset) * Math.sin(theta)) / a2, 2.0) + Math.pow(((f0 - xOffset) * Math.sin(theta) + (f1 - yOffset) * Math.cos(theta)) / b, 2.0) - r;
        solution.constraints()[0] = constraint[0];
        solution.constraints()[1] = constraint[1];
    }
}

