/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.lsmop;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.problem.multiobjective.lsmop.functions.Function;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public abstract class AbstractLSMOP
extends AbstractDoubleProblem {
    protected int nk;
    protected List<Integer> subLen;
    protected List<Integer> len;

    protected AbstractLSMOP(int nk, int numberOfVariables, int numberOfObjectives) {
        int i;
        double c;
        int i2;
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(numberOfObjectives);
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (i2 = 0; i2 < this.getNumberOfObjectives() - 1; ++i2) {
            lowerLimit.add(0.0);
            upperLimit.add(1.0);
        }
        for (i2 = this.getNumberOfObjectives() - 1; i2 < this.getNumberOfVariables(); ++i2) {
            lowerLimit.add(0.0);
            upperLimit.add(10.0);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
        this.nk = nk;
        double sum = c = 0.342;
        ArrayList<Double> c_list = new ArrayList<Double>(this.getNumberOfObjectives());
        c_list.add(c);
        for (i = 0; i < this.getNumberOfObjectives() - 1; ++i) {
            c = 3.8 * c * (1.0 - c);
            c_list.add(c);
            sum += c;
        }
        this.subLen = new ArrayList<Integer>(this.getNumberOfObjectives());
        for (i = 0; i < this.getNumberOfObjectives(); ++i) {
            int aux = (int)Math.floor((Double)c_list.get(i) / sum * (double)(this.getNumberOfVariables() - this.getNumberOfObjectives() + 1) / (double)this.nk);
            this.subLen.add(aux);
        }
        this.len = new ArrayList<Integer>(this.subLen.size() + 1);
        this.len.add(0);
        int cum = 0;
        for (int i3 = 0; i3 < this.getNumberOfObjectives(); ++i3) {
            this.len.add(cum += this.subLen.get(i3) * this.nk);
        }
    }

    protected abstract Function getOddFunction();

    protected abstract Function getEvenFunction();

    @Override
    protected abstract List<Double> evaluate(List<Double> var1);

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        ArrayList<Double> variables = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            variables.add((Double)solution.variables().get(i));
        }
        List<Double> y = this.evaluate((List<Double>)variables);
        for (int i = 0; i < this.getNumberOfObjectives(); ++i) {
            solution.objectives()[i] = y.get(i);
        }
        return solution;
    }
}

